<div class="form-group" id="add-comportamiento">
<?php
use kartik\grid\GridView;
use kartik\builder\TabularForm;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;
use yii\widgets\Pjax;

$dataProvider = new ArrayDataProvider([
    'allModels' => $row,
    'pagination' => [
        'pageSize' => -1
    ]
]);
echo TabularForm::widget([
    'dataProvider' => $dataProvider,
    'formName' => 'Comportamiento',
    'checkboxColumn' => false,
    'actionColumn' => false,
    'attributeDefaults' => [
        'type' => TabularForm::INPUT_TEXT,
    ],
    'attributes' => [
        "id" => ['type' => TabularForm::INPUT_HIDDEN, 'columnOptions' => ['hidden'=>true]],
        'calificacion' => ['type' => TabularForm::INPUT_TEXT],
        'docente' => [
            'label' => 'Tercero',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => Yii::t('app', 'Choose Tercero')],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'estudiante' => [
            'label' => 'Tercero',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => Yii::t('app', 'Choose Tercero')],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'grupo' => [
            'label' => 'Grupo',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grupo::find()->orderBy('grupo')->asArray()->all(), 'id', 'grupo'),
                'options' => ['placeholder' => Yii::t('app', 'Choose Grupo')],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'periodo' => [
            'label' => 'Periodo',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Periodo::find()->orderBy('periodo')->asArray()->all(), 'id', 'periodo'),
                'options' => ['placeholder' => Yii::t('app', 'Choose Periodo')],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'observacion_general' => ['type' => TabularForm::INPUT_TEXT],
        'observacion_especifica' => ['type' => TabularForm::INPUT_TEXT],
        'creado_el' => ['type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\datecontrol\DateControl::classname(),
            'options' => [
                'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                'saveFormat' => 'php:Y-m-d H:i:s',
                'ajaxConversion' => true,
                'options' => [
                    'pluginOptions' => [
                        'placeholder' => Yii::t('app', 'Choose Creado El'),
                        'autoclose' => true,
                    ]
                ],
            ]
        ],
        'creado_por' => ['type' => TabularForm::INPUT_TEXT],
        'actualizado_el' => ['type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\datecontrol\DateControl::classname(),
            'options' => [
                'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                'saveFormat' => 'php:Y-m-d H:i:s',
                'ajaxConversion' => true,
                'options' => [
                    'pluginOptions' => [
                        'placeholder' => Yii::t('app', 'Choose Actualizado El'),
                        'autoclose' => true,
                    ]
                ],
            ]
        ],
        'actualizado_por' => ['type' => TabularForm::INPUT_TEXT],
        'eliminado_el' => ['type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\datecontrol\DateControl::classname(),
            'options' => [
                'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                'saveFormat' => 'php:Y-m-d H:i:s',
                'ajaxConversion' => true,
                'options' => [
                    'pluginOptions' => [
                        'placeholder' => Yii::t('app', 'Choose Eliminado El'),
                        'autoclose' => true,
                    ]
                ],
            ]
        ],
        'eliminado_por' => ['type' => TabularForm::INPUT_TEXT],
        'estado' => ['type' => TabularForm::INPUT_TEXT],
        'del' => [
            'type' => 'raw',
            'label' => '',
            'value' => function($model, $key) {
                return
                    Html::hiddenInput('Children[' . $key . '][id]', (!empty($model['id'])) ? $model['id'] : "") .
                    Html::a('<i class="glyphicon glyphicon-trash"></i>', '#', ['title' =>  Yii::t('app', 'Delete'), 'onClick' => 'delRowComportamiento(' . $key . '); return false;', 'id' => 'comportamiento-del-btn']);
            },
        ],
    ],
    'gridSettings' => [
        'panel' => [
            'heading' => false,
            'type' => GridView::TYPE_DEFAULT,
            'before' => false,
            'footer' => false,
            'after' => Html::button('<i class="glyphicon glyphicon-plus"></i>' . Yii::t('app', 'Add Comportamiento'), ['type' => 'button', 'class' => 'btn btn-success kv-batch-create', 'onClick' => 'addRowComportamiento()']),
        ]
    ]
]);
echo  "    </div>\n\n";
?>

