<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Comportamientoestudiante */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Comportamientoestudiante'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="comportamientoestudiante-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= Yii::t('app', 'Comportamientoestudiante').' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        'compromiso:ntext',
        'creado_el',
        'creado_por',
        'actualizado_el',
        'actualizado_por',
        'eliminado_por',
        'eliminado_el',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    
    <div class="row">
<?php
if($providerComportamiento->totalCount){
    $gridColumnComportamiento = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
            'calificacion',
                        [
                'attribute' => 'docente0.id',
                'label' => Yii::t('app', 'Docente')
            ],
            [
                'attribute' => 'estudiante0.id',
                'label' => Yii::t('app', 'Estudiante')
            ],
            [
                'attribute' => 'grupo0.grupo',
                'label' => Yii::t('app', 'Grupo')
            ],
            [
                'attribute' => 'periodo0.periodo',
                'label' => Yii::t('app', 'Periodo')
            ],
            'observacion_general',
            'observacion_especifica',
            'creado_el',
            'creado_por',
            'actualizado_el',
            'actualizado_por',
            'eliminado_el',
            'eliminado_por',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerComportamiento,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-comportamiento']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode(Yii::t('app', 'Comportamiento')),
        ],
        'export' => false,
        'columns' => $gridColumnComportamiento
    ]);
}
?>

    </div>
</div>
