<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use yii\web\JsExpression;
use kartik\switchinput\SwitchInput;
use kartik\widgets\DatePicker;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;
use kartik\widgets\FileInput;


$this->title = 'Activar';
$this->params['breadcrumbs'][] = ['label' => 'Compromisos del Acudiente', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

?>
     <?php $form = ActiveForm::begin([
        'validateOnSubmit' => true,
        'enableAjaxValidation' => true,
        'type' => ActiveForm::TYPE_VERTICAL,
        'options' => ['class' => 'main-task-form',
                      'enctype'=>'multipart/form-data',
                    ]
    ]); ?>
    
<div class="row">
    <div class = "col-sm-12">
        <?= $form->errorSummary($model); ?>
    </div>
</div>

<?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>

<div class="row gutter">
    <div class="col-lg-3 col-md-4 col-sm-12 col-xs-12">
        <div class="thumbnail">
            <?= Html::img('@web/images/matricula-estudiantil.png', ['class'=>'img-responsive']); ?>

            <h3 class="center-align-text" style="display:block;"><?= $model->sede ?></h3>
        </div>
    </div>       


            
    <div class="col-lg-9 col-md-8 col-sm-12 col-xs-12">
        <div class="thumbnail" style="padding: 20px !important;">
            <div class="row">
                <div class="col-sm-12">
                    <h3 class="text-primary">Activar Módulo de Compromisos de Acudiente</h3>
                    <p></p>
                    <p>Deseas activar el módulo para valorar el compromiso de los acudientes y dar reporte en el <span class="text-success"><b>Informe Valorativo del Estudiante</b></span>.</p>
                </div>       
                <div class="col-sm-12">
                    <?= $form->field($model, 'compromiso_acudiente')->widget(SwitchInput::classname(), ['pluginOptions' => [
                        'size' => 'medium',
                        'onColor' => 'success',
                        'offColor' => 'danger',
                        'onText'=>'Si',
                        'offText'=>'No'
                    ]])->label(false) 
                    ?>
                </div>       
                <div class="col-sm-12">
                    <div class="form-group" style="float:right;">
                        <?= Html::submitButton('Activar', ['class' => 'btn btn-primary']); ?>
                        <?= Html::a(Yii::t('app', 'Cancel'), Yii::$app->request->referrer , ['class'=> 'btn btn-danger']) ?>
                    </div>
                </div>        
            </div>
        </div>
    </div>   
</div>  

<?php ActiveForm::end(); ?>           