<?php

use yii\helpers\Html;
use kartik\detail\DetailView;
use kartik\grid\GridView;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\helpers\Json;

use backend\models\base\Departamento;
use backend\models\base\Municipio;
?>
<div class="comuna-view">


    <div class="row">
<?php 
   
    $gridColumn = [
        [
            'group'=>true,
            'label'=>'Información Básica',
            'rowOptions'=>['class'=>'info']
        ],
        [
            'columns' =>[
                [
                    'attribute' => 'nombre',
                    'valueColOptions'=>['style'=>'width:80%'],
                ],    
            ],
        ],
        [
            'columns' => [
                [
                    'attribute'=>'departamento',
                    'value'=>$model->departamentos->nombre,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Departamento::find()->asArray()->all(), 'id', 'nombre'),
                    ],
                ],
                [
                    'attribute'=>'municipio',
                    'value'=>$model->municipios->nombre,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Municipio::find()->asArray()->all(), 'id', 'nombre'),
                    ],
                ],
                
            ],
        ],            
 ];

    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn,
        'mode' => 'view',
        'enableEditMode' => false,
        'bordered' => true,
        'striped' => false,
        'panel' => [
            'heading' => 'Información Detallada',
            'type' => DetailView::TYPE_SUCCESS,
        ],
        'condensed' => false,
        'responsive' => true,
        'hover' => true,
        'hAlign'=> 'center',
        'vAlign'=> 'center',
        'fadeDelay'=> '1000',
        'deleteOptions'=>[ // your ajax delete parameters
            //'params' => ['id' => 1000, 'kvdelete'=>true],
                'params' => ['custom_param'=>true],
                'url'=>['delete', 'id' => $model->id],
        ],
        'container' => ['id'=>'kv-demo'],
        'formOptions' => ['action' => Url::current(['#' => 'delete'])] // your action to delete
    ]);
?>
    </div>
</div>