<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;

use backend\models\Departamento;
use backend\models\Municipio;

/*
\mootensai\components\JsBlock::widget(['viewFile' => '_script', 'pos'=> \yii\web\View::POS_END, 
    'viewParams' => [
        'class' => 'Barrio', 
        'relID' => 'barrio', 
        'value' => \yii\helpers\Json::encode($model->barrios),
        'isNewRecord' => ($model->isNewRecord) ? 1 : 0
    ]
]);*/
?>

<?php $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario',
                          'enctype'=>'multipart/form-data',
                        ]
        ]); ?>

<div class="comuna-form">

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información de Carga Académica</h3>
    </div>

    <div class="panel-body" >

            <?= $form->errorSummary($model); ?>

    <div class="col-sm-6">
        <?= $form->field($model, 'nombre')->textInput(['maxlength' => true, 'placeholder' => 'Nombre']) ?>
    </div>       
    <div class="col-sm-6">
        <?= $form->field($model, 'departamento')->widget(Select2::classname(), [
            'data' => ArrayHelper::map(Departamento::find()->orderBy('id')->asArray()->all(), 'id', 'nombre'),
            'options' => ['id'=>'dep-id'],
            'pluginOptions' => [
                'placeholder' => 'Seleccione Departamento',
                'allowClear' => true,
            ],
        ]) ?>
    </div>       
    <div class="col-sm-6">
        <?= $form->field($model, 'municipio')->widget(DepDrop::classname(), [
            'data' => ArrayHelper::map(Municipio::find()->where(['=', 'departamento', $model->departamento])->orderBy('id')->asArray()->all(), 'id', 'nombre'),
            'type'=>DepDrop::TYPE_SELECT2,
            'options'=>['id'=>'mun-id'],
            'pluginOptions'=>[
                'placeholder'=>'Seleccione Municipio',
                'depends'=>['dep-id'],
                'url'=>Url::to(['findmunicipios']),
            ]
        ]);
        ?>  
    </div>         

    </div>
</div>
    
<!--
    <div class="form-group" id="add-barrio"></div>
-->
    <?php ActiveForm::end(); ?>

</div>
