<?php


use yii\helpers\Html;
use kartik\detail\DetailView;
use kartik\grid\GridView;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\helpers\Json;

use backend\models\base\Departamento;
use backend\models\base\Municipio;

/* @var $this yii\web\View */
/* @var $model backend\models\base\Comuna */

$this->title = $model->nombre;
$this->params['breadcrumbs'][] = ['label' => 'Comunas o Corregimientos', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $model->nombre, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = 'Ver';
?>
<div class="comuna-view">


    <div class="row">
<?php 
   
    $gridColumn = [
        [
            'group'=>true,
            'label'=>'Información Básica',
            'rowOptions'=>['class'=>'info']
        ],
        [
            'columns' =>[
                [
                    'attribute' => 'nombre',
                    'valueColOptions'=>['style'=>'width:80%'],
                ],    
            ],
        ],
        [
            'columns' => [
                [
                    'attribute'=>'departamento',
                    'value'=>$model->departamentos->nombre,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Departamento::find()->asArray()->all(), 'id', 'nombre'),
                    ],
                ],
                [
                    'attribute'=>'municipio',
                    'value'=>$model->municipios->nombre,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Municipio::find()->asArray()->all(), 'id', 'nombre'),
                    ],
                ],
                
            ],
        ],            
 ];

    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn,
        'mode' => 'view',
        'enableEditMode' => false,
        'bordered' => true,
        'striped' => false,
        'panel' => [
            'heading' => 'Información Detallada',
            'type' => DetailView::TYPE_SUCCESS,
        ],
        'condensed' => false,
        'responsive' => true,
        'hover' => true,
        'hAlign'=> 'center',
        'vAlign'=> 'center',
        'fadeDelay'=> '1000',
        'deleteOptions'=>[ // your ajax delete parameters
            //'params' => ['id' => 1000, 'kvdelete'=>true],
                'params' => ['custom_param'=>true],
                'url'=>['delete', 'id' => $model->id],
        ],
        'container' => ['id'=>'kv-demo'],
        'formOptions' => ['action' => Url::current(['#' => 'delete'])] // your action to delete
    ]);
?>
    </div>
    
    <div class="row">
<?php
if($providerBarrio->totalCount){
    $gridColumnBarrio = [
        ['class' => 'yii\grid\SerialColumn'],
            'nombre',
            [
                'attribute' => 'departamentos.nombre',
                'label' => 'Departamento'
        ],
            [
                'attribute' => 'municipios.nombre',
                'label' => 'Municipio'
        ],
            [
                'attribute' => 'comunas.nombre',
                'label' => 'Comuna'
        ],
    ];
    echo Gridview::widget([
        'dataProvider' => $providerBarrio,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-barrio']],
        'panel' => [
        'type' => GridView::TYPE_INFO,
        'heading' => '<span class="glyphicon glyphicon-info-sign"></span> ' . Html::encode('Barrios'.' de '. $model->nombre),
        ],
        'columns' => $gridColumnBarrio
    ]);
}
?>
    </div>
</div>