<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;
use kartik\widgets\TouchSpin;


use backend\models\TipoCondicion;
use backend\models\Grado;
use backend\models\Area;
use backend\models\Asignatura;
use backend\models\Desempeno;

$this->registerJs("

    $('#condicionpromocion-tipo').change(function(){

        tipo = $('#condicionpromocion-tipo').val();
        
        if (tipo == 1)
        {
            $('#grado-id').val('').change();
            $('#area-id').val('').change();
            $('#asignatura-id').val('').change();
            $('#desempeno-id').val('').change();
            $('#numeroareas-id').val('').change();
            $('#numeroasignaturas-id').val('').change();
            $('#numeroausentismo-id').val('').change();
            $('#descripcion-id').val('').change();

            $('#grado').show(500);
            $('#area').show(500);
            $('#asignatura').hide(500);
            $('#desempeno').show(500);
            $('#numero_areas').hide(500);
            $('#numero_asignaturas').hide(500);
            $('#numero_ausentismo').hide(500);
            $('#descripcion').show(500);
            $('#estado').show(500);
        }

        if (tipo == 2)
        {
            $('#grado-id').val('').change();
            $('#area-id').val('').change();
            $('#asignatura-id').val('').change();
            $('#desempeno-id').val('').change();
            $('#numeroareas-id').val('').change();
            $('#numeroasignaturas-id').val('').change();
            $('#numeroausentismo-id').val('').change();
            $('#descripcion-id').val('').change();

            $('#grado').show(500);
            $('#area').hide(500);
            $('#asignatura').show(500);
            $('#desempeno').show(500);
            $('#numero_areas').hide(500);
            $('#numero_asignaturas').hide(500);
            $('#numero_ausentismo').hide(500);
            $('#descripcion').show(500);
            $('#estado').show(500);
            $('#area-id').val('').change();
        }

        if (tipo == 3)
        {
            $('#grado-id').val('').change();
            $('#area-id').val('').change();
            $('#asignatura-id').val('').change();
            $('#desempeno-id').val('').change();
            $('#numeroareas-id').val('').change();
            $('#numeroasignaturas-id').val('').change();
            $('#numeroausentismo-id').val('').change();
            $('#descripcion-id').val('').change();

            $('#area').hide(500);
            $('#grado').hide(500);
            $('#asignatura').hide(500);
            $('#desempeno').hide(500);
            $('#numero_areas').show(500);
            $('#numero_asignaturas').hide(500);
            $('#numero_ausentismo').hide(500);
            $('#descripcion').show(500);
            $('#estado').show(500);
        }

        if (tipo == 4)
        {
            $('#grado-id').val('').change();
            $('#area-id').val('').change();
            $('#asignatura-id').val('').change();
            $('#desempeno-id').val('').change();
            $('#numeroareas-id').val('').change();
            $('#numeroasignaturas-id').val('').change();
            $('#numeroausentismo-id').val('').change();
            $('#descripcion-id').val('').change();

            $('#area').hide(500);
            $('#grado').hide(500);
            $('#asignatura').hide(500);
            $('#desempeno').hide(500);
            $('#numero_areas').hide(500);
            $('#numero_asignaturas').show(500);
            $('#numero_ausentismo').hide(500);
            $('#descripcion').show(500);
            $('#estado').show(500);
        }

        if (tipo == 5)
        {
            $('#grado-id').val('').change();
            $('#area-id').val('').change();
            $('#asignatura-id').val('').change();
            $('#desempeno-id').val('').change();
            $('#numeroareas-id').val('').change();
            $('#numeroasignaturas-id').val('').change();
            $('#numeroausentismo-id').val('').change();
            $('#descripcion-id').val('').change();

            $('#area').hide(500);
            $('#grado').hide(500);
            $('#asignatura').hide(500);
            $('#desempeno').hide(500);
            $('#numero_areas').hide(500);
            $('#numero_asignaturas').hide(500);
            $('#numero_ausentismo').show(500);
            $('#descripcion').show(500);
            $('#estado').show(500);
        }

    });
");


?>

    <?php 

        $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                            'id' => 'formulario',
                        ]
        ]); 
    ?>


<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información de Condición de Promoción</h3>
    </div>

    <div class="panel-body" >

            <?= $form->errorSummary($model); ?>

        <div class="col-sm-6">
            <?= $form->field($model, 'tipo')->widget(\kartik\widgets\Select2::classname(), [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Tipocondicion::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                'options' => ['placeholder' => Yii::t('app', 'Seleccione')],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ]); ?>
        </div>

        <div class="clear"></div>
    
        <div id="grado" class="col-sm-3" style="display:none;">
            <?= $form->field($model, 'grado')->widget(\kartik\widgets\Select2::classname(), [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::find()->orderBy('id')->asArray()->all(), 'id', 'grado'),
                'options' => ['id'=>'grado-id','placeholder' => Yii::t('app', 'Seleccione')],
                'pluginOptions' => [
                    'allowClear' => true,
                    //'multiple' => true,
                ],
            ]); ?>
        </div>
        <div id="area" class="col-sm-3" style="display:none;">
            <?= $form->field($model, 'area')->widget(DepDrop::classname(), [
                'type'=>DepDrop::TYPE_SELECT2,
                //'data' => ArrayHelper::map(Area::find()->where(['=', 'grado', $model->grado])->orderBy('id')->asArray()->all(), 'id', 'asignatura'),
                'options'=>[
                    'id'=>'area-id',
                    'allowClear' => true,
                    'multiple' => true,
                    'placeholder'=>'Seleccione el Área',
                ],
                //'select2Options' => ['pluginOptions' => ['allowClear' => true]],
                'pluginOptions'=>[
                    
                    'depends'=>['grado-id'],
                    'url'=>Url::to(['publica/findareasxgrado']),
                ]
            ]);
            ?> 
        </div>
        <div id="asignatura" class="col-sm-3" style="display:none;">
            <?= $form->field($model, 'asignatura')->widget(DepDrop::classname(), [
                'type'=>DepDrop::TYPE_SELECT2,
                'data' => ArrayHelper::map(Asignatura::find()->where(['=', 'grado', $model->grado])->orderBy('id')->asArray()->all(), 'id', 'asignatura'),
                'options'=>[
                    'id'=>'asignatura-id',
                    'allowClear' => true,
                    'multiple' => true,
                    'placeholder'=>'Seleccione la Asignatura',
                ],
                //'select2Options' => ['pluginOptions' => ['allowClear' => true]],
                'pluginOptions'=>[
                    
                    'depends'=>['grado-id'],
                    'url'=>Url::to(['publica/findasignaturasnoexcluidas']),
                ]
            ]);
            ?> 
        
        </div>
        <div id="desempeno" class="col-sm-3" style="display:none;">
            <div class="col-sm-2">
                <h3 class="text-danger" style="text-align: center; padding-top: 5px;"><=</h3>    
            </div>
            <div class="col-sm-10">
                <?= $form->field($model, 'desempeno')->widget(DepDrop::classname(), [
                    'type'=>DepDrop::TYPE_SELECT2,
                    //'data' => ArrayHelper::map(Desempeno::find()->where(['tipo_calificacion' => $model->grados->tipo_calificacion])->orderBy('id')->asArray()->all(), 'id', 'desempeno'),
                    'options'=>['id'=>'desempeno-id'],
                    'pluginOptions'=>[
                        'placeholder'=>'Seleccione el Desempeño',
                        'depends'=>['grado-id'],
                        'url'=>Url::to(['publica/finddesempenos']),
                    ]
                ]);
                ?>
            </div>
        </div>
        <div id="numero_areas" class="col-sm-3" style="display:none;">
            <?= $form->field($model, 'numero_areas')->widget(TouchSpin::classname(), ['options' => ['id' => 'numeroareas-id', 'placeholder' => 'Áreas'],]);?>
        </div>
        <div id="numero_asignaturas" class="col-sm-3" style="display:none;">
            <?= $form->field($model, 'numero_asignaturas')->widget(TouchSpin::classname(), ['options' => ['id' => 'numeroasignaturas-id', 'placeholder' => 'Asignaturas'],]);?>
        </div>
        <div id="numero_ausentismo" class="col-sm-3" style="display:none;">
            <?= $form->field($model, 'numero_ausentismo')->widget(TouchSpin::classname(), ['options' => ['id' => 'numeroausentismo-id', 'placeholder' => 'Ausentismo'],]);?>
        </div>
        <div id="descripcion" class="col-sm-3" style="display:none;">
            <?= $form->field($model, 'descripcion')->textinput(['id' => 'descripcion-id', 'placeholder' => Yii::t('app', 'Descripción')]) ?>
        </div>
        <div id="estado" class="col-sm-12" style="display:none;">
            <? ($model->isNewRecord) ? $model->estado = true: ''; ?>

            <?= $form->field($model, 'estado')->widget(SwitchInput::classname(), ['pluginOptions' => [
                'size' => 'medium',
                'onColor' => 'success',
                'offColor' => 'danger',
                'onText'=>'Activo',
                'offText'=>'Inactivo'
            ]]) 
            ?>
        </div>

    </div>
    <?php ActiveForm::end(); ?>

</div>




<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Condiciones de Promoción</h3>
    </div>

    <div class="panel-body" >


        <?= $this->render('index', [
            'model' => $model,
            'condiciones' => $condiciones,
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]) ?>

    </div>
</div>

