<?php

/* @var $this yii\web\View */
/* @var $searchModel backend\models\CondicionpromocionSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use kartik\export\ExportMenu;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;
/*
$this->title = Yii::t('app', 'Condición de Promoción');
$this->params['breadcrumbs'][] = $this->title;


$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];

$search = "$('.search-button').click(function(){
	$('.search-form').toggle(1000);
	return false;
});";

$this->registerJs($search);
*/
?>
<div class="condicionpromocion-index">
    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>

    <?php 
    $gridColumn = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => false],
        [
                'attribute' => 'tipo',
                'label' => Yii::t('app', 'Tipo'),
                'value' => function($model){                   
                    return $model->tipos->tipo;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\TipoCondicion::find()->asArray()->all(), 'id', 'tipo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Tipo de Condición', 'id' => 'grid-condicionpromocion-search-tipo'],
                'group' => true,

            ],
        [
                'attribute' => 'grado',
                'label' => Yii::t('app', 'Grado'),
                'value' => function($model){
                    if ($model->grados)
                    {return $model->grados->grado;}
                    else
                    {return '';}
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::find()->asArray()->all(), 'id', 'grado'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Grado', 'id' => 'grid-condicionpromocion-search-grado'],
                'group' => true,
            ],
        [
                'attribute' => 'area',
                'label' => Yii::t('app', 'Area'),
                'value' => function($model){
                    if ($model->areas)
                    {return $model->areas->area;}
                    else
                    {return '';}
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Area::find()->asArray()->all(), 'id', 'area'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Área', 'id' => 'grid-condicionpromocion-search-area']
            ],
        [
                'attribute' => 'asignatura',
                'label' => Yii::t('app', 'Asignatura'),
                'value' => function($model){
                    if ($model->asignaturas)
                    {return $model->asignaturas->asignatura;}
                    else
                    {return '';}
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Asignatura::find()->asArray()->all(), 'id', 'asignatura'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Asignatura', 'id' => 'grid-condicionpromocion-search-asignatura']
            ],
        [
            'label' => Yii::t('app', 'Condición'),
            'format' => 'raw',
            'value' => function($model){
                return '<center><span class="label label-danger"><=</span></center>';
            },
        ],
        [
            'attribute' => 'desempeno',
            'label' => Yii::t('app', 'Desempeño'),
            'format' => 'raw',
            'value' => function($model){
                if ($model->desempenos)            
                {
                    return '<center><span class="label" style="width:50px; background-color:'.$model->desempenos->color.'; color:#fff">'.$model->desempenos->desempeno.'</span></center>';
                }
                else
                {return '';}
            },
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Desempeno::find()->asArray()->all(), 'id', 'desempeno'),
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
            ],
            'filterInputOptions' => ['placeholder' => 'Desempeño', 'id' => 'grid-condicionpromocion-search-desempeno']
        ],
        'numero_areas',
        'numero_asignaturas',
        'numero_ausentismo',
        [       
            'attribute' => 'descripcion',
            'visible' => false,
        ],
        [
            'class'=>'kartik\grid\BooleanColumn',
            'attribute'=>'estado', 
            'vAlign'=>'middle'
        ],
        [
            'class' => 'yii\grid\ActionColumn',
            'headerOptions' => ['style' => 'width:90px'],
        ],
    ]; 
    ?>


<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading' => false,
                //'heading'=>'<i class="fa fa-users"></i>  Terceros',
                //'before' =>  '<div style="padding-top: 7px;"><em>Estudiantes, Docentes, Administrativos y Acudientes.</em></div>',
                //'after' => '{summary}',
                'footer'=> '{summary}',
            ],        
            'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fa fa-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="fa fa-repeat"></i>', ['index'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Volver a Cargar'])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],
        ],
        'options'=>['id'=>'condicionpromocion'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>

</div>
