<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Condicionpromocion */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Condicionpromocion'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="condicionpromocion-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= Yii::t('app', 'Condicionpromocion').' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'tipos.id',
            'label' => Yii::t('app', 'Tipo'),
        ],
        [
            'attribute' => 'grados.grado',
            'label' => Yii::t('app', 'Grado'),
        ],
        [
            'attribute' => 'areas.area',
            'label' => Yii::t('app', 'Area'),
        ],
        [
            'attribute' => 'asignaturas.asignatura',
            'label' => Yii::t('app', 'Asignatura'),
        ],
        [
            'attribute' => 'desempenos.desempeno',
            'label' => Yii::t('app', 'Desempeno'),
        ],
        'numero_areas',
        'numero_asignaturas',
        'numero_ausentismo',
        'descripcion:ntext',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>




    
</div>
