<?php

use yii\helpers\Html;
use kartik\detail\DetailView;
use kartik\grid\GridView;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\helpers\Json;

use backend\models\Departamento;

/* @var $this yii\web\View */
/* @var $model backend\models\base\Departamento */

$this->title = 'Ver Departamento: ' . ' ' . $model->nombre;
$this->params['breadcrumbs'][] = ['label' => 'Departamentos', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $model->nombre, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = 'Ver';
?>
<div class="departamento-view">


    <div class="row">
<?php 
    /*
    if ($model->tipo_tercero==1) $color="success";
    if ($model->tipo_tercero==2) $color="info";
    if ($model->tipo_tercero==3) $color="warning";
    if ($model->tipo_tercero==4) $color="danger";
*/
    $gridColumn = [
        [
            'group'=>true,
            'label'=>'Información Básica',
            'rowOptions'=>['class'=>'info']
        ],
        [
            'columns' => [
                [
                    'attribute'=>'id',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                [
                    'attribute' => 'nombre',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                
            ],
        ], 
           
 ];

    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn,
        'mode' => 'view',
        'enableEditMode' => false,
        'bordered' => true,
        'striped' => false,
        'panel' => [
            'heading' => 'Información Detallada',
            'type' => DetailView::TYPE_SUCCESS,
        ],
        'condensed' => false,
        'responsive' => true,
        'hover' => true,
        'hAlign'=> 'center',
        'vAlign'=> 'center',
        'fadeDelay'=> '1000',
        'deleteOptions'=>[ // your ajax delete parameters
            //'params' => ['id' => 1000, 'kvdelete'=>true],
                'params' => ['custom_param'=>true],
                'url'=>['delete', 'id' => $model->id],
        ],
        'container' => ['id'=>'kv-demo'],
        'formOptions' => ['action' => Url::current(['#' => 'delete'])] // your action to delete
    ]);
?>
    </div>
    
    <div class="row">
<?php
if($providerBarrio->totalCount){
    $gridColumnBarrio = [
        ['class' => 'yii\grid\SerialColumn'],
            'id',
            'nombre',
            [
                'attribute' => 'departamentos.nombre',
                'label' => 'Departamento'
        ],
            [
                'attribute' => 'municipios.nombre',
                'label' => 'Municipio'
        ],
            [
                'attribute' => 'comunas.nombre',
                'label' => 'Comuna'
        ],
    ];
    echo Gridview::widget([
        'dataProvider' => $providerBarrio,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-barrio']],
        'panel' => [
        'type' => GridView::TYPE_INFO,
        'heading' => '<span class="glyphicon glyphicon-info-sign"></span> ' . Html::encode('Barrios'.' de '. $model->nombre),
        ],
        'columns' => $gridColumnBarrio
    ]);
}
?>
    </div>
    
    <div class="row">
<?php
if($providerComuna->totalCount){
    $gridColumnComuna = [
        ['class' => 'yii\grid\SerialColumn'],
            'id',
            'nombre',
            [
                'attribute' => 'departamentos.nombre',
                'label' => 'Departamento'
        ],
            [
                'attribute' => 'municipios.nombre',
                'label' => 'Municipio'
        ],
    ];
    echo Gridview::widget([
        'dataProvider' => $providerComuna,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-comuna']],
        'panel' => [
        'type' => GridView::TYPE_INFO,
        'heading' => '<span class="glyphicon glyphicon-info-sign"></span> ' . Html::encode('Comunas'.' de '. $model->nombre),
        ],
        'columns' => $gridColumnComuna
    ]);
}
?>
    </div>
    
    <div class="row">
<?php
if($providerMunicipio->totalCount){
    $gridColumnMunicipio = [
        ['class' => 'yii\grid\SerialColumn'],
            'id',
            'dane',
            'nombre',
            [
                'attribute' => 'departamento.id',
                'label' => 'Departamento'
        ],
    ];
    echo Gridview::widget([
        'dataProvider' => $providerMunicipio,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-municipio']],
        'panel' => [
        'type' => GridView::TYPE_INFO,
        'heading' => '<span class="glyphicon glyphicon-info-sign"></span> ' . Html::encode('Municipios'.' de '. $model->nombre),
        ],
        'columns' => $gridColumnMunicipio
    ]);
}
?>
    </div>
</div>