<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->desempenoniveles,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'grados.grado',
                'label' => 'Grado'
        ],
        [
                'attribute' => 'asignaturas.asignatura',
                'label' => 'Asignatura'
        ],
        [
                'attribute' => 'periodos.periodo',
                'label' => 'Periodo'
        ],
        [
                'attribute' => 'competencias.competencia',
                'label' => 'Competencia'
        ],
        [
                'attribute' => 'desempeno',
                'label' => 'Desempeño',
                'format' => 'RAW',
                'value' => function ($model) {
                            return '<h3><span class="label" style="background-color:'.$model->desempenos->color.'; color:#fff">'.$model->desempenos->desempeno.'</span></h3>';
                           } 
        ],
        'descripcion:ntext',
        //'recomendacion:ntext',
        //'estado',
        [
            'class' => 'yii\grid\ActionColumn',
            'controller' => 'desempeno-nivel'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
