<?php

use yii\helpers\Html;
use kartik\detail\DetailView;
use kartik\grid\GridView;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\helpers\Json;

use backend\models\base\Tipocalificacion;

?>
<div class="desempeno-view">

    <div class="row">
        <div class="col-sm-12">
            <h2><?= Html::encode($model->desempeno) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 

    $gridColumn = [
        [
            'group'=>true,
            'label'=>'Información Básica',
            'rowOptions'=>['class'=>'info']
        ],
        [
            'columns' => [
                [
                    'attribute'=>'desempeno',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                [
                    'attribute'=>'tipo_calificacion',
                    'value' => $model->tipoCalificaciones->tipo,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Tipocalificacion::find()->asArray()->all(), 'id', 'tipo'),
                    ],
                ],
                
            ],
        ], 
        [
            'columns' => [
                [
                    'attribute'=>'limite_inferior',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'visible' => $model->tipo_calificacion == 1 ? false : true,
                ],
                [
                    'attribute'=>'limite_superior',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'visible' => $model->tipo_calificacion == 1 ? false : true,
                ],
                
            ],
        ], 
        [    
            'columns' => [

                [
                    'attribute' => 'nota',
                    'label' => 'Nota',
                    'format' => 'RAW',
                    'value' => '<span class="label" style="background-color:'.$model->color.'; color:#fff">'.$model->nota.'</span>',
                    'valueColOptions'=>['style'=>'width:30%'],
                ], 
                [
                    'attribute' => 'estado',
                    'format' => 'RAW',
                    'value' => ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],           
                
            ],
        ],
           
 ];

    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn,
        'mode' => 'view',
        'enableEditMode' => false,
        'bordered' => true,
        'striped' => false,
        'panel' => [
            'heading' => 'Información Detallada',
            'type' => DetailView::TYPE_SUCCESS,
        ],
        'condensed' => false,
        'responsive' => true,
        'hover' => true,
        'hAlign'=> 'center',
        'vAlign'=> 'center',
        'fadeDelay'=> '1000',
        'deleteOptions'=>[ // your ajax delete parameters
            //'params' => ['id' => 1000, 'kvdelete'=>true],
                'params' => ['custom_param'=>true],
                'url'=>['delete', 'id' => $model->id],
        ],
        'container' => ['id'=>'kv-demo'],
        'formOptions' => ['action' => Url::current(['#' => 'delete'])] // your action to delete
    ]);
?>
    </div>
</div>