<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\ColorInput;


$search = "$('#desempeno-tipo_calificacion').change(function(){
    if (this.value == 1) 
    { 
        document.getElementById('desempeno-limite_inferior').value='';
        document.getElementById('desempeno-limite_superior').value='';
        $('#limites').hide(500);
    }
    else
    {   
        $('#limites').show(500);
    }    
});";

$this->registerJs($search);

?>
    <?php 

        $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                            'id' => 'formulario',
                        ]
        ]); 
    ?>

    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información del Desempeño</h3>
        </div>

    <div class="panel-body" >

            <?= $form->errorSummary($model); ?>

        <div class="col-sm-6">
            <?= $form->field($model, 'desempeno')->textInput(['maxlength' => true, 'placeholder' => 'Desempeño']) ?>
        </div>
        <div class="col-sm-6">    
            <?= $form->field($model, 'tipo_calificacion')->widget(\kartik\widgets\Select2::classname(), [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Tipocalificacion::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                'options' => ['placeholder' => 'Seleccione el Sistema de Calificación'],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ]) ?>
        </div>
        
        <? 
            if ($model->isNewRecord) 
            { 
                $visible ='none';
            } 
            else
            {
                if ($model->tipo_calificacion != 1)
                {
                    $visible ='block';    
                }
                else
                {
                    $visible ='none';
                } 
                
            } 
        ?>
        
        <div id='limites' style="display:<?= $visible ?>">
            <div class="col-sm-6">
                <?= $form->field($model, 'limite_inferior')->textInput(['maxlength' => true, 'placeholder' => 'Limite Inferior']) ?>
            </div>
            <div class="col-sm-6">
                <?= $form->field($model, 'limite_superior')->textInput(['maxlength' => true, 'placeholder' => 'Limite Superior']) ?>
            </div>
        </div>
        <div class="col-sm-6">    
            <? if ($model->isNewRecord) 
               { 
                    echo $form->field($model, 'color')->widget(ColorInput::classname(), ['options' => ['placeholder' => 'Select Color...'],]);     
               } 
               else
               {
                    echo $form->field($model, 'color')->widget(ColorInput::classname(), [
                         'options' => ['placeholder' => 'Seleccione el Color', 'readonly' => true],
                         'pluginOptions' => [
                                'allowClear' => true
                          ],
                        ]);       } 
            ?>
        </div>
        <div class="col-sm-6">    
            <?= $form->field($model, 'nota')->textInput(['maxlength' => true, 'placeholder' => 'Nota']) ?>
        </div>

        <div class="col-sm-6">
            <?= $form->field($model, 'emoticons')->widget(\kartik\widgets\Select2::classname(), [
                'data' => ['data-thumbnail' => 'images/icon-chrome.png'],
                'options' => ['placeholder' => 'Seleccione el Sistema de Calificación'],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ]) ?> 
        </div>
        
        <div class="col-sm-6">
            <?= $form->field($model, 'perdido')->widget(SwitchInput::classname(), ['pluginOptions' => [
                'onColor' => 'primary',
                'offColor' => 'warning',
                'onText'=>'Si',
                'offText'=>'No'
            ]]) 
            ?> 
        </div>
    </div>
</div>

<?php ActiveForm::end(); ?>
