<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Desempeno */

$this->title = $model->desempeno;
$this->params['breadcrumbs'][] = ['label' => 'Desempenos', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="desempeno-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Desempeno'.' '. Html::encode($this->title) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        'desempeno',
        [
                'attribute' => 'tipoCalificaciones.tipo',
                'label' => 'Tipo Calificación'
        ],
        [
                'attribute' => 'limite_inferior',
                'visible' => $model->tipo_calificacion == 1 ? false : true,
        ],
        [
                'attribute' => 'limite_superior',
                'visible' => $model->tipo_calificacion == 1 ? false : true,
        ],
        [
                'attribute' => 'nota',
                'format' => 'raw',
                'value' => '<h3><span class="label" style="background-color:'.$model->color.'; color:#fff">&nbsp;&nbsp;'.$model->nota.'&nbsp;&nbsp;</span></h3>',
        ],
        //'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
    $gridColumnDesempenonivel = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'grados.grado',
                'label' => 'Grado'
        ],
        [
                'attribute' => 'asignaturas.asignatura',
                'label' => 'Asignatura'
        ],
        [
                'attribute' => 'periodos.periodo',
                'label' => 'Periodo'
        ],
        [
                'attribute' => 'competencias.competencia',
                'label' => 'Competencia'
        ],
        [
                'attribute' => 'desempenos.desempeno',
                'label' => 'Desempeno'
        ],
        'descripcion:ntext',
        'recomendacion:ntext',
        'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerDesempenonivel,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-desempeno-nivel']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Nivel de Desempeño'.' '. $this->title),
        ],
        'columns' => $gridColumnDesempenonivel
    ]);
?>
    </div>
</div>
