<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model backend\models\DesempenoSearch */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="form-desempeno-search">

    <?php $form = ActiveForm::begin([
        'action' => ['index'],
        'method' => 'get',
    ]); ?>

    <?= $form->field($model, 'desempeno')->textInput(['maxlength' => true, 'placeholder' => 'Desempeno']) ?>

    <?= $form->field($model, 'tipo_calificacion')->widget(\kartik\widgets\Select2::classname(), [
        'data' => \yii\helpers\ArrayHelper::map(\backend\models\Tipocalificacion::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
        'options' => ['placeholder' => 'Choose Tipo calificacion'],
        'pluginOptions' => [
            'allowClear' => true
        ],
    ]) ?>

    <?= $form->field($model, 'limite_inferior')->textInput(['maxlength' => true, 'placeholder' => 'Limite Inferior']) ?>

    <?= $form->field($model, 'limite_superior')->textInput(['maxlength' => true, 'placeholder' => 'Limite Superior']) ?>

    <?= $form->field($model, 'color')->textInput(['maxlength' => true, 'placeholder' => 'Color']) ?>

    <?php /* echo $form->field($model, 'nota')->textInput(['maxlength' => true, 'placeholder' => 'Nota']) */ ?>

    <?php /* echo $form->field($model, 'estado')->textInput(['placeholder' => 'Estado']) */ ?>

    <div class="form-group">
        <?= Html::submitButton('Search', ['class' => 'btn btn-primary']) ?>
        <?= Html::resetButton('Reset', ['class' => 'btn btn-default']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
