<?php


use yii\helpers\Html;
use kartik\detail\DetailView;
use kartik\grid\GridView;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\helpers\Json;

use backend\models\base\Tipocalificacion;


$this->title = 'Desempeños';
$this->params['breadcrumbs'][] = ['label' => 'Desemepeños', 'url' => ['index']];
$this->params['breadcrumbs'][] = 'Ver';

$this->params['actions'][] = ['label' => 'Actualizar', 'url' => 'update', 'id' => $model->id, 'icon' => '<i class="far fa-pencil"></i>', 'class' => 'primary'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'PDF', 'url' => 'pdf', 'id' => $model->id, 'icon' => '<i class="far fa-file-pdf"></i>', 'class' => 'danger'];
$this->params['actions'][] = ['label' => 'Eliminar', 'url' => 'delete', 'id' => $model->id, 'icon' => '<i class="far fa-trash-alt"></i>', 'class' => 'danger'];

?>


<div class="desempeno-view">

    <div class="row">
<?php 

    $gridColumn = [
        [
            'group'=>true,
            'label'=>'Información Básica',
            'rowOptions'=>['class'=>'info']
        ],
        [
            'columns' => [
                [
                    'attribute'=>'desempeno',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                [
                    'attribute'=>'tipo_calificacion',
                    'value' => $model->tipoCalificaciones->tipo,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Tipocalificacion::find()->asArray()->all(), 'id', 'tipo'),
                    ],
                ],
                
            ],
        ], 
        [
            'columns' => [
                [
                    'attribute'=>'limite_inferior',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'visible' => $model->tipo_calificacion == 1 ? false : true,
                ],
                [
                    'attribute'=>'limite_superior',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'visible' => $model->tipo_calificacion == 1 ? false : true,
                ],
                
            ],
        ], 
        [    
            'columns' => [

                [
                    'attribute' => 'nota',
                    'label' => 'Nota',
                    'format' => 'RAW',
                    'value' => '<h3><span class="label" style="background-color:'.$model->color.'; color:#fff">'.$model->nota.'</span></h3>',
                    'valueColOptions'=>['style'=>'width:30%'],
                ], 
                [
                    'attribute' => 'estado',
                    'format' => 'RAW',
                    'value' => ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],           
                
            ],
        ],
           
 ];

    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn,
        'mode' => 'view',
        'enableEditMode' => false,
        'bordered' => true,
        'striped' => false,
        'panel' => [
            'heading' => 'Información Detallada',
            'type' => DetailView::TYPE_SUCCESS,
        ],
        'condensed' => false,
        'responsive' => true,
        'hover' => true,
        'hAlign'=> 'center',
        'vAlign'=> 'center',
        'fadeDelay'=> '1000',
        'deleteOptions'=>[ // your ajax delete parameters
            //'params' => ['id' => 1000, 'kvdelete'=>true],
                'params' => ['custom_param'=>true],
                'url'=>['delete', 'id' => $model->id],
        ],
        'container' => ['id'=>'kv-demo'],
        'formOptions' => ['action' => Url::current(['#' => 'delete'])] // your action to delete
    ]);
?>
    </div>



</div>