<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model backend\models\Desempenofrd */
/* @var $form yii\widgets\ActiveForm */

?>

<div class="desempenofrd-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->errorSummary($model); ?>

    <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>

    <?= $form->field($model, 'competencia')->widget(\kartik\widgets\Select2::classname(), [
        'data' => \yii\helpers\ArrayHelper::map(\backend\models\Competencia::find()->orderBy('id')->asArray()->all(), 'id', 'competencia'),
        'options' => ['placeholder' => 'Choose Competencia'],
        'pluginOptions' => [
            'allowClear' => true
        ],
    ]); ?>

    <?= $form->field($model, 'desempeno')->widget(\kartik\widgets\Select2::classname(), [
        'data' => \yii\helpers\ArrayHelper::map(\backend\models\Desempeno::find()->orderBy('id')->asArray()->all(), 'id', 'desempeno'),
        'options' => ['placeholder' => 'Choose Desempeno'],
        'pluginOptions' => [
            'allowClear' => true
        ],
    ]); ?>

    <?= $form->field($model, 'fortaleza')->textarea(['rows' => 6]) ?>

    <?= $form->field($model, 'debilidad')->textarea(['rows' => 6]) ?>

    <?= $form->field($model, 'recomendacion')->textarea(['rows' => 6]) ?>

    <?= $form->field($model, 'estado')->textInput(['placeholder' => 'Estado']) ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
