<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Desempenofrd */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Desempenofrds', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="desempenofrd-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Desempenofrd'.' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Delete', ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => 'Are you sure you want to delete this item?',
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'competencia0.competencia',
            'label' => 'Competencia',
        ],
        [
            'attribute' => 'desempeno0.desempeno',
            'label' => 'Desempeno',
        ],
        'fortaleza:ntext',
        'debilidad:ntext',
        'recomendacion:ntext',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    <div class="row">
        <h4>Competencia<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnCompetencia = [
        ['attribute' => 'id', 'visible' => false],
        'grado',
        'asignatura',
        'periodo',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->competencia0,
        'attributes' => $gridColumnCompetencia    ]);
    ?>
    <div class="row">
        <h4>Desempeno<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnDesempeno = [
        ['attribute' => 'id', 'visible' => false],
        'tipo_calificacion',
        'limite_inferior',
        'limite_superior',
        'color',
        'nota',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->desempeno0,
        'attributes' => $gridColumnDesempeno    ]);
    ?>
</div>
