<?php

use yii\helpers\Html;
use yii\helpers\Url;
use backend\models\Periodo;

?>

<div class="row bloques">
    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
    	<h4 class="list-group-item-heading">
    		<?= Html::encode($model->asignaturas->asignatura) ?>
    	</h4>
        <p class="list-group-item-text"><span class="label label-info"><?= Html::encode($model->grupos->grupo); ?></span></p>
        <p class="list-group-item-text"><span class="label label-success"><?= Html::encode($model->grupos->sedes->sede); ?></span></p>
    </div>

    <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
    		<div class="btn-group"> 
    			<?= Html::a(Html::img('@web/images/asistencia.png', ['class'=>'btn-acciones']).'Asistencia', ['asistencia/asistencia', 'asignatura' => $model->asignatura, 'grupo' => $model->grupo], ['class' => 'btn btn-sm btn-info wacciones']) ?>   
                <?= Html::a('<span class="caret"></span>', ['#'], ['class' => 'btn btn-info dropdown-acciones dropdown-toggle', 'data-toggle' => 'dropdown']); ?>

                <ul class="dropdown-menu">
                    <li><?= Html::a('<i class="far fa-list text-primary" aria-hidden="true"></i> Reporte de Asistencia', ['reporte101/index', 'asignatura' => $model->asignatura, 'grupo' => $model->grupo]) ?></li>
                    <li class="divider"></li>
                    <li><?= Html::a('Listado de Asistencia', ['reporte102/index', 'asignatura' => $model->asignatura, 'grupo' => $model->grupo]) ?></li>

                    <!--<li><?= Html::a('Listado de Estudiantes', false, ['onclick'=> 'generar('.$model->asignatura.','.$model->grupo.');', 'data-style' => 'zoom-in', 'style' => 'cursor: pointer;']) ?></li>-->
                
                    <!--<li><?= Html::a('<i class="fa fa-table text-success" aria-hidden="true"></i> Listado de Estudiantes', ['reporte102', 'asignatura' => $model->asignatura, 'grupo' => $model->grupo]) ?></li>-->
                <!--    <li class="divider"></li>
                    <li><a href="#">Opción 4</a></li>-->
                </ul>
            </div>

            <div class="btn-group">
                <?= Html::a(Html::img('@web/images/tareas.png', ['class'=>'btn-acciones']).'Tareas', ['tarea/create', 'asignatura' => $model->asignatura, 'grupo' => $model->grupo], ['class' => 'btn btn-sm btn-danger wacciones']) ?>   
                <?= Html::a('<span class="caret"></span>', ['#'], ['class' => 'btn btn-danger dropdown-acciones dropdown-toggle', 'data-toggle' => 'dropdown']); ?>

                <ul class="dropdown-menu">
                    <li><?= Html::a('<i class="far fa-list text-danger" aria-hidden="true"></i> Listado de Entregas', ['tareadesarrollo/index', 'TareaSearch[asignatura]' => $model->asignatura, 'CompetenciaSearch[grado]' => $model->grupos->grados->id]) ?></li>
                    <li class="divider"></li>
                    <li><?= Html::a('<i class="fa fa-university text-success" aria-hidden="true"></i> Observaciones Generales', ['obsgeneral/index']) ?></li>
                </ul>
            </div>  

            <div class="btn-group">

            	<?= Html::a(Html::img('@web/images/observaciones.png', ['class'=>'btn-acciones']).'Observador', ['observador/create', 'asignatura' => $model->asignatura, 'grupo' => $model->grupo], ['class' => 'btn btn-sm btn-success wacciones']) ?>   
        	    
                <?= Html::a('<span class="caret"></span>', ['#'], ['class' => 'btn btn-success dropdown-acciones dropdown-toggle', 'data-toggle' => 'dropdown']); ?>

                <ul class="dropdown-menu">
                    <!--<li><?= Html::a('Reporte de Calificaciones', ['/reporte101', 'asignatura' => $model->asignatura, 'grupo' => $model->grupo]) ?></li>-->
                    <!--<li class="divider">
                    <li><?= Html::a('Reporte de Calificaciones', ['/reporte101', 'asignatura' => $model->asignatura, 'grupo' => $model->grupo]) ?></li>-->
                </ul>
            </div>   


    
    <?php 
        
        if($model->grupos->sedes->autorizar_calificaciones == 1) 
        {
            for ($p=1; $p<=$periodo->actual->id; $p++) 
            { 
                switch ($p) 
                {
                    case '1':
                        $color = 'cyan';
                        break;
                    case '2':
                        $color = 'warning';
                        break;
                    case '3':
                        $color = 'primary';
                        break;
                    case '4':
                        $color = 'danger';
                        break;
                    default:
                        $color = 'purple';
                        break;
                }

                $periodo_recurrente = Periodo::find()->where(['id' => $p])->one();      

                if ($periodo_recurrente->autorizar_calificaciones == 1)
                {
            
    ?>

    		<div class="btn-group"> 
    			<?= Html::a(Html::img('@web/images/calificaciones.png', ['class'=>'btn-acciones']).'Calificaciones <span class="badge badge-pill badge-success">P'.$p.'</span>', ['calificacion/calificaciones', 'asignatura' => $model->asignatura, 'grupo' => $model->grupo, 'periodo' => $p], ['class' => 'btn btn-sm btn-'.$color.' wacciones', 'data-style' => 'zoom-in']); ?>

                <?= Html::a('<span class="caret"></span>', ['#'], ['class' => 'btn btn-'.$color.' dropdown-acciones dropdown-toggle', 'data-toggle' => 'dropdown']); ?>

                <ul class="dropdown-menu">
                    <li><?= Html::a('Calificar Acudiente', ['calificacioncompromisos/calificaciones', 'grupo' => $model->grupo, 'periodo' => $p]) ?></li>
                	<li class="divider">
                    <!--<li><?= Html::a('Reporte de Calificaciones', ['reporte101/index', 'asignatura' => $model->asignatura, 'grupo' => $model->grupo]) ?></li>    -->
                    <li><?= Html::a('Certificado de Publicación', ['reporte501/index', 'asignatura' => $model->asignatura, 'grupo' => $model->grupo, 'periodo' => $p]) ?></li>
                </ul>
            </div>
    
    <? }}} ?>


    <?php if($model->grupos->sedes->autorizar_nivelaciones == 1) { ?>

            <div class="btn-group"> 
                <?= Html::a(Html::img('@web/images/calificaciones.png', ['class'=>'btn-acciones']).'Nivelaciones', ['calificacion/nivelaciones', 'asignatura' => $model->asignatura, 'grupo' => $model->grupo], ['class' => 'btn btn-sm btn-danger wacciones', 'data-style' => 'zoom-in']); ?>

                <?= Html::a('<span class="caret"></span>', ['#'], ['class' => 'btn btn-danger dropdown-acciones dropdown-toggle', 'data-toggle' => 'dropdown']); ?>

                <ul class="dropdown-menu">
                    <li><?= Html::a('Calificar Acudiente', ['calificacioncompromisos/calificaciones', 'grupo' => $model->grupo]) ?></li>
                </ul>
            </div>

    <?php } ?>


    <?php if($model->director_area == 1) { ?>

            <div class="btn-group"> 
                <?= Html::a(Html::img('@web/images/calificaciones.png', ['class'=>'btn-acciones']).'Área', ['calificacion/area', 'area' => $model->asignaturas->area, 'grupo' => $model->grupo], ['class' => 'btn btn-sm btn-warning wacciones', 'data-style' => 'zoom-in']); ?>

                <?= Html::a('<span class="caret"></span>', ['#'], ['class' => 'btn btn-warning dropdown-acciones dropdown-toggle', 'data-toggle' => 'dropdown']); ?>

                <ul class="dropdown-menu">
                    <li><?= Html::a('Calificar Acudiente', ['calificacioncompromisos/calificaciones', 'grupo' => $model->grupo]) ?></li>
                </ul>
            </div>

    <?php } ?>


    			<? Html::a('<i class="fa fa-list-alt"></i>', ['reporte/exportar_asistencia', 'asignatura' => $model->asignatura, 'grupo' => $model->grupo], ['class' => 'btn btn-sm btn-warning  hidden-xs', 'data-style' => 'zoom-in']) ?>
    			
    			<? Html::a('<i class="fa fa-thumbs-up"></i> Niveles de Desempeño', ['desempenonivel/create', 'asignatura' => $model->asignatura, 'grupo' => $model->grupo], ['class' => 'btn btn-sm btn-primary']) ?>

    		<div class="btn-group">
    			<?= Html::a(Html::img('@web/images/plandeaula.png', ['class'=>'btn-acciones']).'Planes', false, ['class' => 'btn btn-sm btn-cyan wacciones']) ?>   
                <?= Html::a('<span class="caret"></span>', ['#'], ['class' => 'btn btn-cyan dropdown-acciones dropdown-toggle', 'data-toggle' => 'dropdown']); ?>

                <ul class="dropdown-menu">
                	<li><?= Html::a('<i class="fa fa-trophy text-warning" aria-hidden="true"></i> Plan de Aula', ['planaula/index', 'PlanaulaSearch[asignatura]' => $model->asignatura, 'PlanaulaSearch[grupo]' => $model->grupo]) ?></li>
                    <li><?= Html::a('<i class="fa fa-signal text-primary" aria-hidden="true"></i> Plan de Mejoramiento', ['planmejoramiento/index', 'PlanmejoramientoSearch[asignatura]' => $model->asignatura, 'PlanmejoramientoSearch[grupo]' => $model->grupos->id]) ?></li>

                    <!--<li><?= Html::a('<i class="fa fa-university text-success" aria-hidden="true"></i> Observaciones FRD', ['frd/index', 'FrdSearch[asignatura]' => $model->asignatura, 'FrdSearch[grado]' => $model->grupo]) ?></li>-->
                    
                    <li class="divider"></li>
                    <li><?= Html::a('<i class="fa fa-university text-success" aria-hidden="true"></i> Observaciones Generales', ['obsgeneral/index']) ?></li>
                </ul>
            </div>
<!--
            <div class="btn-group">
                <?= Html::a(Html::img('@web/images/curriculum.png', ['class'=>'btn-acciones']).'Académico', false, ['class' => 'btn btn-sm btn-purple wacciones']) ?>   
                <?= Html::a('<span class="caret"></span>', ['#'], ['class' => 'btn btn-purple dropdown-acciones dropdown-toggle', 'data-toggle' => 'dropdown']); ?>

                <ul class="dropdown-menu">
                    <li><?= Html::a('<i class="fa fa-trophy text-warning" aria-hidden="true"></i> Competencias', ['competencia/index', 'CompetenciaSearch[asignatura]' => $model->asignatura, 'CompetenciaSearch[grado]' => $model->grupos->grados->id]) ?></li>
                    <li><?= Html::a('<i class="fa fa-signal text-primary" aria-hidden="true"></i> Niveles de Desempeño', ['nivel/index', 'NivelSearch[asignatura]' => $model->asignatura, 'NivelSearch[grado]' => $model->grupos->grados->id]) ?></li>
                    
                    <li class="divider"></li>
                    <li><?= Html::a('<i class="fa fa-university text-success" aria-hidden="true"></i> Observaciones Generales', ['obsgeneral/index']) ?></li>
                </ul>
            </div>	
-->        
    </div>
    
</div>
