<?php


use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;


$this->title = 'Lanzador Docente';
$this->params['breadcrumbs'][] = ['label' => 'Reportes', 'url' => ['index']];
$this->params['breadcrumbs'][] = 'Buscar Reporte';

$this->registerJs("
    
  $(document).ready(function(){
    
    load_data();

    function load_data(query)
    {
        $('#result').html('<div style=\'text-align:center;\'><img src=\'".Url::to('@web/images/loading.gif')."\' width=\'50px\' height=\'50px\'></div>'); 
      
        $.ajax({
         url:'".Url::to(['buscar'])."',
         method:'POST',
         data:{query:query},
         success:function(data)
         {
          $('#result').html(data);
         }
        });
    }
   
    $('#tercero-primer_nombre').keyup(function()
    {
        var search = $(this).val();
        if(search != '')
        {
          load_data(search);
        }
        else
        {
          load_data();
        }
    });

        

   });

");



?>
   <?php $form = ActiveForm::begin([
      'type' => ActiveForm::TYPE_VERTICAL,
      'options' => ['class' => 'main-task-form',
                    'id' => 'formulario',
                  ]
  ]); ?>

<script type="text/javascript">
    

    function cambiar_usuario(id,tercero)
    {

      swal({
          title: '¿Deseas cambiar de usuario?',
          text: 'Deseas cambiar al panel de ' + tercero + ', recuerda que cambiarán tus roles y privilegios...',
          type: 'warning',
          showCancelButton: true,
          confirmButtonClass: 'btn-warning',
          confirmButtonText: 'Si, estoy seguro!',
          cancelButtonText: 'No, Cancelar',
          closeOnConfirm: false,
          closeOnCancel: false
        },
        function(isConfirm) {
          if (isConfirm) 
          {
            $.ajax({
                    type: 'GET',
                    url: '<?= Url::to(["docente/cambiar"]) ?>',
                    data: {tercero : id},
                    success: function (data) {
                        swal({
                            title: 'Enhorabuena!',
                            text: 'Se ha el usuario a ' + data + ' satisfactoriamente, serás redirigido al panel nuevamente.',
                            type: 'success',
                            allowOutsideClick: false,
                            timer: 3000,
                        });

                        window.location.href = '<?= Url::to(["../admin"]) ?>';
                    }
            });  
          } 
          else 
          {
              swal({
                title: 'Cancelado!',
                text: 'Haz cancelado el cambio de periodo.',
                type: 'error',
                timer: 3000})
          }
      });
    }  

</script>

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Lanzador Docente</h3>
    </div>

    <div class="panel-body">

      <div class="row">

        <div class="col-sm-3 hidden-xs">
            <?= Html::img('@web/images/sonic-hero.png', ['class'=>'img-responsive hidden-xs']); ?>
        </div>    
    

        <div class="col-sm-9">
            <?= $form->field($model, 'primer_nombre', [
                'addon' => ['prepend' => ['content'=>'<i class="fas fa-search"></i>']],
              ])->label(false); 
            ?>


          <div id="result">
            <?= "<div style='text-align:center;'><img src='".Url::to('@web/images/loading.gif')."' width='50px' height='50px'></div>"; ?>
          </div>        

        </div>
      </div>
    </div>        
</div>

    <?php ActiveForm::end(); ?>
