<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\ColorInput;
use kartik\widgets\DateTimePicker;
use kartik\widgets\Select2;
use kartik\widgets\FileInput;
use kartik\widgets\TouchSpin;
use dosamigos\tinymce\TinyMce;


?>

<?php $form = ActiveForm::begin([
            //'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario',
                          'enctype'=>'multipart/form-data',
                        ]
        ]); ?>

<div class="documento-form">

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información del Archivo</h3>
    </div>

    <div class="panel-body" >

            <?= $form->errorSummary($model); ?>

        <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>

    <div class="col-sm-9">

        <?= $form->field($model, 'titulo')->textInput(['maxlength' => true, 'placeholder' => 'Titulo']) ?>
    </div>       

    <div class="col-sm-3">     

        <?= $form->field($model, 'categoria')->widget(\kartik\widgets\Select2::classname(), [
            'data' => \yii\helpers\ArrayHelper::map(\backend\models\Documentocategoria::find()->orderBy('id')->asArray()->all(), 'id', 'categoria'),
            'options' => ['placeholder' => Yii::t('app', 'Choose Documento categoria')],
            'pluginOptions' => [
                'allowClear' => true
            ],
        ]); ?>
    </div>       

    <div class="col-sm-6">     

        <?= $form->field($model, 'contenido')->widget(TinyMce::className(), [
            'options' => ['rows' => 15],
            'language' => 'es',
            'clientOptions' => [
                'plugins' => [
                    "advlist autolink lists link charmap print preview anchor",
                    "searchreplace visualblocks code fullscreen",
                    "insertdatetime media image table contextmenu paste"
                ],
                'toolbar' => "undo redo | copy cut paste pastetext | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link media table image",
            ]
        ])->label();?>

    </div>       

    <div class="col-sm-6">     

        <?= $form->field($model, 'archivo')->widget(FileInput::classname(), [
            'options' => ['multiple'=>false],
            'pluginOptions'=>[
                //'uploadUrl' => Url::to(['/site/file-upload']),
                //'allowedFileExtensions'=>['jpg', 'gif', 'png', 'bmp','pdf','doc', 'docx','xls'],
                'previewFileType' => 'any',
                'showUpload' => false,
                'overwriteInitial' => false,
                'browseClass' => 'btn btn-primary',
                'uploadClass' => 'btn btn-success',
                'removeClass' => 'btn btn-danger',
                'removeIcon' => '<i class="glyphicon glyphicon-trash"></i>',
                ],
        ])->label(); ?>

    </div>       

    <div class="col-sm-3">     

        <? ($model->isNewRecord) ? $model->descargas = 0 : $model->descargas; ?>
        <?= $form->field($model, 'descargas')->widget(TouchSpin::classname(), ['options' => ['placeholder' => 'Descargas'],]);?>
    </div>       

    <div class="col-sm-3">     
        
        <? ($model->isNewRecord) ? $model->estado = true: ''; ?>

        <?= $form->field($model, 'estado')->widget(SwitchInput::classname(), ['pluginOptions' => [
            'size' => 'medium',
            'onColor' => 'success',
            'offColor' => 'danger',
            'onText'=>'Activo',
            'offText'=>'Inactivo'
        ]]) 
        ?>
    </div>


    </div>
</div>

    <?php ActiveForm::end(); ?>

</div>