<?php

use yii\helpers\Html;
use kartik\export\ExportMenu;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;

//$this->title = 'Asignaturas';
$this->title = Yii::t('app', 'Categorías de Documentos');

$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];

$this->params['breadcrumbs'][] = $this->title;
$search = "$('.search-button').click(function(){
	$('.search-form').toggle(1000);
	return false;
});";
$this->registerJs($search);
?>
<div class="documentocategoria-index">

    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>
    <?php 
    $gridColumn = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => false],
        'categoria',
        [
            'attribute' => 'padre',
            'label' => Yii::t('app', 'Padre'),
            'value' => function($model){
                if ($model->padres)
                {return $model->padres->categoria;}
                else
                {return NULL;}
            },
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Documentocategoria::find()->asArray()->all(), 'id', 'categoria'),
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
            ],
            'filterInputOptions' => ['placeholder' => 'Documento categoria', 'id' => 'grid-documentocategoria-search-padre']
        ],
        [
            'attribute' => 'carpeta',
            'format' => 'raw',
            'label' => Yii::t('app', 'Carpeta'),
            'value' => function($model){
                
                $carpeta = Yii::getAlias('@frontend') . "/web/documentos/".$model->carpeta;

                if (!is_dir($carpeta))
                {
                    if (!is_writable($carpeta))
                    {
                        return $model->carpeta.'&nbsp;<span class="label label-danger">No Existe</label>';
                    }
                }
                else
                {
                    if (!is_writable($carpeta))
                    {
                        return $model->carpeta.'&nbsp;<span class="label label-success">Existe</span>&nbsp;<span class="label label-danger">No Escribible</span>';
                    }
                    else
                    {
                        return $model->carpeta.'&nbsp;<span class="label label-success">Existe</span>&nbsp;<span class="label label-success">Escribible</span>';
                    }
                }  
            },
        ],
        'carpeta',
        [
            'class'=>'kartik\grid\BooleanColumn',
            'attribute'=>'estado', 
            'vAlign'=>'middle'
        ],
        [
            'class'=>'kartik\grid\ActionColumn',
            'dropdown'=>false,
            'order'=>DynaGrid::ORDER_FIX_RIGHT
        ],

    ]; 
    ?>



<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading' => false,
                //'heading'=>'<i class="fa fa-users"></i>  Terceros',
                //'before' =>  '<div style="padding-top: 7px;"><em>Estudiantes, Docentes, Administrativos y Acudientes.</em></div>',
                //'after' => '{summary}',
                'footer'=> '{summary}',
            ],        
            'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fa fa-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="fa fa-repeat"></i>', ['index'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Volver a Cargar'])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],
        ],
        'options'=>['id'=>'documentocategoria'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>  


</div>
