<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Documentocategoria */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Documentocategoria'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="documentocategoria-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= Yii::t('app', 'Documentocategoria').' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        'categoria',
        [
            'attribute' => 'padre0.id',
            'label' => Yii::t('app', 'Padre'),
        ],
        'carpeta',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    
    <div class="row">
<?php
if($providerDocumento->totalCount){
    $gridColumnDocumento = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
            'titulo',
                        'contenido:ntext',
            'archivo:ntext',
            'descargas',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerDocumento,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-documento']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode(Yii::t('app', 'Documento')),
        ],
        'export' => false,
        'columns' => $gridColumnDocumento
    ]);
}
?>

    </div>
    <div class="row">
        <h4>Documentocategoria<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnDocumentocategoria = [
        ['attribute' => 'id', 'visible' => false],
        'categoria',
        'carpeta',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->padre0,
        'attributes' => $gridColumnDocumentocategoria    ]);
    ?>
    
    <div class="row">
<?php
if($providerDocumentocategoria->totalCount){
    $gridColumnDocumentocategoria = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
            'categoria',
                        'carpeta',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerDocumentocategoria,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-documento-categoria']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode(Yii::t('app', 'Documentocategoria')),
        ],
        'export' => false,
        'columns' => $gridColumnDocumentocategoria
    ]);
}
?>

    </div>
</div>
