<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\ColorInput;
use kartik\widgets\DateTimePicker;
use kartik\widgets\Select2;
use kartik\widgets\FileInput;
use kartik\widgets\TouchSpin;
use dosamigos\tinymce\TinyMce;


?>

<?php $form = ActiveForm::begin([
    //'validateOnSubmit' => true,
    'type' => ActiveForm::TYPE_VERTICAL,
    'options' => ['class' => 'main-task-form',
                  'id' => 'formulario',
                  'enctype'=>'multipart/form-data',
                ]
]); ?>

<div class="enlace-form">

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información del Enlace</h3>
    </div>

    <div class="panel-body" >

        <?= $form->errorSummary($model); ?>

        <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>

    <div class="col-sm-9">
        <?= $form->field($model, 'titulo')->textInput(['maxlength' => true, 'placeholder' => 'Titulo']) ?>
    </div>       

    <div class="col-sm-3">     
    
        <?= $form->field($model, 'categoria')->widget(\kartik\widgets\Select2::classname(), [
            'data' => \yii\helpers\ArrayHelper::map(\backend\models\Enlacecategoria::find()->orderBy('id')->asArray()->all(), 'id', 'categoria'),
            'options' => ['placeholder' => Yii::t('app', 'Seleccione Categoría')],
            'pluginOptions' => [
                'allowClear' => true
            ],
        ]); ?>
    </div>       

    <div class="col-sm-6">     
        <?= $form->field($model, 'enlace')->textInput(['maxlength' => true, 'placeholder' => 'Enlace']) ?>
    </div>

    <div class="col-sm-6">     
        <?= $form->field($model, 'descripcion')->textInput(['maxlength' => true, 'placeholder' => 'Descripcion']) ?>
    </div>

    <div class="col-sm-3">     
        <?= $form->field($model, 'target')->widget(\kartik\widgets\Select2::classname(), [
            'data' => ['_blank' => 'Nueva Ventana', '_self' => 'Misma Ventana'],
            'options' => ['placeholder' => Yii::t('app', 'Seleccione Categoría')],
            'pluginOptions' => [
                'allowClear' => true
            ],
        ]); ?>
    </div>       
    
    <div class="col-sm-3">     
        <? ($model->isNewRecord) ? $model->descargas = 0 : $model->descargas; ?>
        <?= $form->field($model, 'descargas')->widget(TouchSpin::classname(), ['options' => ['placeholder' => 'Descargas'],]);?>
    </div>       

    <div class="col-sm-3">     
        
        <? ($model->isNewRecord) ? $model->estado = true: ''; ?>

        <?= $form->field($model, 'estado')->widget(SwitchInput::classname(), ['pluginOptions' => [
            'size' => 'medium',
            'onColor' => 'success',
            'offColor' => 'danger',
            'onText'=>'Activo',
            'offText'=>'Inactivo'
        ]]) 
        ?>
    </div>


    </div>
</div>

    <?php ActiveForm::end(); ?>

</div>