<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\ColorInput;
use kartik\widgets\DateTimePicker;
use kartik\widgets\Select2;
use kartik\widgets\FileInput;
use kartik\widgets\TouchSpin;
use dosamigos\tinymce\TinyMce;


?>

<?php $form = ActiveForm::begin([
    //'validateOnSubmit' => true,
    'type' => ActiveForm::TYPE_VERTICAL,
    'options' => ['class' => 'main-task-form',
                  'id' => 'formulario',
                  'enctype'=>'multipart/form-data',
                ]
]); ?>

<div class="documento-form">

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información de la Categoría</h3>
    </div>

    <div class="panel-body" >

        <?= $form->errorSummary($model); ?>

        <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>

    <div class="col-sm-12">
        <?= $form->field($model, 'categoria')->textInput(['maxlength' => true, 'placeholder' => 'Categoria']) ?>
    </div>       

    <div class="col-sm-12">     
        <?= $form->field($model, 'descripcion')->widget(TinyMce::className(), [
            'options' => ['rows' => 15],
            'language' => 'es',
            'clientOptions' => [
                'plugins' => [
                    "advlist autolink lists link charmap print preview anchor",
                    "searchreplace visualblocks code fullscreen",
                    "insertdatetime media image table contextmenu paste"
                ],
                'toolbar' => "undo redo | copy cut paste pastetext | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link media table image",
            ]
        ])->label(false);?>
    </div>       

    <div class="col-sm-3">     
        
        <? ($model->isNewRecord) ? $model->estado = true: ''; ?>

        <?= $form->field($model, 'estado')->widget(SwitchInput::classname(), ['pluginOptions' => [
            'size' => 'medium',
            'onColor' => 'success',
            'offColor' => 'danger',
            'onText'=>'Activo',
            'offText'=>'Inactivo'
        ]]) 
        ?>
    </div>


    </div>
</div>

    <?php ActiveForm::end(); ?>

</div>