<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->terceros,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => '', 
                'format' => 'raw',
                'width' => '50px',
                'value' => function($model){
                    return Html::img($model->foto ? '@web/uploads/thumbnail/sm-'.$model->foto : '@web/images/user.jpg', ['class'=>'img-36 rounded-circle']);
                },
                'filter'=>false,
                'visible' => true
            ],
        'identificacion',
        [
                'attribute' => 'tipos.tipo',
                'label' => 'Tipo'
        ],
        'primer_nombre',
        'segundo_nombre',
        'primer_apellido',
        'segundo_apellido',
        [
                'attribute' => 'generos.genero',
                'label' => 'Genero'
        ],
        'fecha_nacimiento',
        [
                'attribute' => 'departamentos.nombre',
                'label' => 'Departamento Nacimiento'
        ],
        [
                'attribute' => 'municipios.nombre',
                'label' => 'Municipio Nacimiento'
        ],
        [
                'attribute' => 'rhs.rh',
                'label' => 'Rh'
        ],
        [
                'attribute' => 'religiones.religion',
                'label' => 'Religion'
        ],
        [
                'attribute' => 'etnias.etnia',
                'label' => 'Etnia'
        ],
        'direccion',
        [
                'attribute' => 'barrio.id',
                'label' => 'Barrio'
        ],
        'fijo',
        'movil',
        'email:email',
        //'acudiente',
        /*[
                'attribute' => 'estado',
                'format' => 'RAW',
                'value' => ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>'
        ],*/ 
        [
            'class' => 'yii\grid\ActionColumn',
            'contentOptions'=>['style'=>'width: 80px;'],
            'controller' => 'tercero'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
