<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;

/* @var $this yii\web\View */
/* @var $model backend\models\base\Especialidad */
/* @var $form yii\widgets\ActiveForm */

\mootensai\components\JsBlock::widget(['viewFile' => '_script', 'pos'=> \yii\web\View::POS_END, 
    'viewParams' => [
        'class' => 'Grupo', 
        'relID' => 'grupo', 
        'value' => \yii\helpers\Json::encode($model->grupos),
        'isNewRecord' => ($model->isNewRecord) ? 1 : 0
    ]
]);
?>

<div class="especialidad-form">

    <?php 

        $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                            'id' => 'formulario',
                        ]
        ]); 
    ?>
    
    <?= $form->errorSummary($model); ?>

    <?= $form->field($model, 'especialidad')->textInput(['maxlength' => true, 'placeholder' => 'Especialidad']) ?>

    <?= $form->field($model, 'estado')->widget(SwitchInput::classname(), []) ?>

    <div class="form-group" id="add-grupo"></div>

    <?php ActiveForm::end(); ?>

</div>
