<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;

use kartik\widgets\DepDrop;

use backend\models\Grado;
use backend\models\Asignatura;
use backend\models\Periodo;

?>
         <?php $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario',
                          'enctype'=>'multipart/form-data',
                        ]
        ]); ?>


    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información del Estandar</h3>
        </div>

    <div class="panel-body" >

            <?= $form->errorSummary($model); ?>

        <div class="col-sm-4">
            <?= $form->field($model, 'grado')->widget(Select2::classname(), [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::getGradobyDocente(Yii::$app->session->get('__tercero')), 'id', 'grado'),
                'pluginOptions' => [
                    'placeholder' => 'Seleccione Grado',
                    'allowClear' => true,
                ],
            ]) ?>
        </div>
        <div class="col-sm-4">    
            <?= $form->field($model, 'asignatura')->widget(DepDrop::classname(), [
                'type'=>DepDrop::TYPE_SELECT2,
                'data' => ArrayHelper::map(Asignatura::find()->where(['=', 'grado', $model->grado])->orderBy('id')->asArray()->all(), 'id', 'asignatura'),
                'pluginOptions'=>[
                    'placeholder'=>'Seleccione la Asignatura',
                    'depends'=>['estandar-grado'],
                    'url'=>Url::to(['findasignaturas']),
                ]
            ]);
            ?>  
        </div>
        <div class="col-sm-4"> 
            <?= $form->field($model, 'periodo')->widget(Select2::classname(), [
                'data' => ArrayHelper::map(Periodo::find()->where(['estado' => 1])->orderBy('id')->asArray()->all(), 'id', 'periodo'),
                'options' => ['id'=>'periodo-id',],
                'pluginOptions' => [
                    'placeholder' => 'Seleccione el Periodo',
                    'allowClear' => true
                ],
            ]) ?>
        </div>

        <div class="col-sm-12"> 
            <?= $form->field($model, 'estandar')->textarea(['rows' => 4]) ?>
        </div>

    </div>
  </div>

<?php ActiveForm::end(); ?>