<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;

use kartik\widgets\DepDrop;

use backend\models\Grado;
use backend\models\Asignatura;
use backend\models\Periodo;


$this->registerJs("

$(document).ready(function() {
    
    $('#aplicar').click(function() {

        $('#aplicar').prop('disabled', true);
        grado = $('#grado-id').val();
        asignatura = $('#asignatura-id').val();
        periodo = $('#periodo-id').val();
        estandar = $('#estandar-estandar').val();

        if(!estandar)
        {
            $('.field-estandar-estandar > .help-block-error').html('<span style=\"color: #a94442\">Estandar no puede estar vacío.</span>');   
        }

        $.ajax({
            type: 'POST',
            url: '". Url::to(['addsave'])."',
            timeout: 1000,

            data: {grado : grado, asignatura: asignatura, periodo : periodo, estandar: estandar},

            success: function (data) {
                
                if(data != '')
                {
                    $('#estandar-id').append($('<option>', {
                        value: data,
                        text: estandar,
                    }));
                    
                    $('#modal').modal('hide'); //ocultamos el modal
                    $('body').removeClass('modal-open');    //eliminamos la clase del body para poder hacer scroll
                    $('.modal-backdrop').remove();  //eliminamos el backdrop del modal

                    swal({
                        title: 'Enhorabuena!',
                        text: 'Se agrego satisfactoriamente.',
                        type: 'success',
                        allowOutsideClick: false,
                        timer: 1000,
                    });
                }
                    
                
            },
            error: function(request, status, err) {
                if (status == 'timeout') {
                    //timeout -> reload the page and try again
                    $('#info').html(\"<i class='fas fa-times text-danger'></i>\");
                    console.log('timeout');
                    //window.location.reload();
                } else {
                    $('#info').html(\"<span class='text-danger'>\"+ err + \"</span>\");
                    //another error occured  
                    //alert('error: ' + request + status + err);
                }
            }
    
        });
        
    });

});

");

?>

 <?php $form = ActiveForm::begin([
    'validateOnSubmit' => true,
    'type' => ActiveForm::TYPE_VERTICAL,
    'options' => ['class' => 'main-task-form',
                  'id' => 'formulario',
                ]
]); ?>

    <div class="row">

        <div class="col-sm-2 hidden-xs">
            <?= Html::img('@web/images/sonic-hero.png', ['class'=>'img-responsive hidden-xs animated bounceInUp','style' => 'position:fixed; z-index:0;']); ?>
        </div>


        <div class="col-sm-10 col-xs-12">
            <?= $form->field($model, 'estandar')->textInput(['maxlength' => true, 'placeholder' => 'Estandar']) ?>
        </div>

        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="text-align:right; padding-top: 10px;">
            <?= Html::Button('<i class="glyphicon glyphicon-plus"></i>' . ' Agregar', ['type' => 'button', 'class' => 'btn btn-success', 'id' => 'aplicar']) ?>
            <?= Html::a('<i class="fa fa-times" aria-hidden="true"></i><span> Cancelar', false , ['class'=> 'btn btn-danger', 'data-dismiss' => 'modal']) ?>        
        </div>
        
    </div>
        
<?php ActiveForm::end(); ?>
