<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\base\Estrato */

$this->title = $model->estrato;
$this->params['breadcrumbs'][] = ['label' => 'Estratos', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="estrato-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Estrato'.' '. Html::encode($this->title) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        'estrato',
        'creado_el',
        'creado_por',
        'actualizado_el',
        'actualizado_por',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
if($providerTercero->totalCount){
    $gridColumnTercero = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => false],
        'identificacion',
        [
                'attribute' => 'tipo0.id',
                'label' => 'Tipo'
            ],
        'primer_nombre',
        'segundo_nombre',
        'primer_apellido',
        'segundo_apellido',
        [
                'attribute' => 'genero0.genero',
                'label' => 'Genero'
            ],
        [
                'attribute' => 'tipoTercero.id',
                'label' => 'Tipo Tercero'
            ],
        'fecha_nacimiento',
        [
                'attribute' => 'departamentoNacimiento.id',
                'label' => 'Departamento Nacimiento'
            ],
        [
                'attribute' => 'municipioNacimiento.id',
                'label' => 'Municipio Nacimiento'
            ],
        [
                'attribute' => 'rh0.rh',
                'label' => 'Rh'
            ],
        [
                'attribute' => 'religion0.religion',
                'label' => 'Religion'
            ],
        [
                'attribute' => 'etnia0.etnia',
                'label' => 'Etnia'
            ],
        [
                'attribute' => 'eps0.eps',
                'label' => 'Eps'
            ],
        'direccion',
        [
                'attribute' => 'barrio0.id',
                'label' => 'Barrio'
            ],
        'fijo',
        'movil',
        'email:email',
        'foto',
                [
                'attribute' => 'situacion0.id',
                'label' => 'Situacion'
            ],
        'codigo_desplazado',
        [
                'attribute' => 'departamentoDesplazado.id',
                'label' => 'Departamento Desplazado'
            ],
        [
                'attribute' => 'municipioDesplazado.id',
                'label' => 'Municipio Desplazado'
            ],
        'codigo_sisben',
        'codigo_familia_accion',
        'capacidad_excepcional',
        'medicamentos',
        'alergias',
        'discapacidad',
        'discapacidad_certificada',
        'subsidio',
        [
                'attribute' => 'recurso0.id',
                'label' => 'Recurso'
            ],
        'bienestar',
        'heroe',
        'fuerza_publica',
        'sector',
        'resguardo',
        [
                'attribute' => 'departamentoResguardo.id',
                'label' => 'Departamento Resguardo'
            ],
        [
                'attribute' => 'municipioResguardo.id',
                'label' => 'Municipio Resguardo'
            ],
        'creado_el',
        'creado_por',
        'actualizado_el',
        'actualizado_por',
        'activo',
        [
                'attribute' => 'estado0.id',
                'label' => 'Estado'
            ],
    ];
    echo Gridview::widget([
        'dataProvider' => $providerTercero,
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Tercero'),
        ],
        'panelHeadingTemplate' => '<h4>{heading}</h4>{summary}',
        'toggleData' => false,
        'columns' => $gridColumnTercero
    ]);
}
?>
    </div>
</div>
