<?php

/* @var $this yii\web\View */
/* @var $searchModel backend\models\EstratoSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use kartik\export\ExportMenu;
use kartik\grid\GridView;

$this->title = 'Estratos';
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];

$search = "$('.search-button').click(function(){
	$('.search-form').toggle(1000);
	return false;
});";
$this->registerJs($search);
?>
<div class="estrato-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Estrato', ['create'], ['class' => 'btn btn-success']) ?>
        <?= Html::a('Advance Search', '#', ['class' => 'btn btn-info search-button']) ?>
    </p>
    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>
    <?php 
    $gridColumn = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => false],
        'estrato',
        'creado_el',
        'creado_por',
        'actualizado_el',
        'actualizado_por',
        'estado',
        [
            'class' => 'yii\grid\ActionColumn',
        ],
    ]; 
    ?>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => $gridColumn,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-estrato']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span>  ' . Html::encode($this->title),
        ],
        // your toolbar can include the additional full export menu
        'toolbar' => [
            '{export}',
            ExportMenu::widget([
                'dataProvider' => $dataProvider,
                'columns' => $gridColumn,
                'target' => ExportMenu::TARGET_BLANK,
                'fontAwesome' => true,
                'dropdownOptions' => [
                    'label' => 'Full',
                    'class' => 'btn btn-default',
                    'itemsBefore' => [
                        '<li class="dropdown-header">Export All Data</li>',
                    ],
                ],
            ]) ,
        ],
    ]); ?>

</div>
