<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\HtmlPurifier;


    $entregas = $model->entregas($model->id);

    if($entregas == 0)
    {
        $tipo = "new";
    }


    $disponible = new DateTime($model->disponible_hasta);
    $ahora = new DateTime('NOW');

    if(($ahora > $disponible) && ($entregas == 0))
    {
        $tipo = "critical";
    }


    if(($ahora < $disponible) && ($entregas > 0))
    {
        $tipo = "bug";
    }

    if(($ahora > $disponible) && ($entregas > 0))
    {
        $tipo = "complete";
    }


?>

<div class="task-block <?= $tipo ?>">
    <h5 class="task-id">
        <a href="<?= Url::to(['view', 'id' => $model->id]) ?>">
            <?= Html::encode($model->tarea) ?>
        </a>
        <i class="far fa-eye"></i>    
    </h5>
    <div class="assigned-user">
        <? 
            if(isset($model->docente))
            {
                echo Html::img($model->docentes->foto ? '@web/uploads/thumbnail/sm-'.$model->docentes->foto : '@web/images/user.jpg', ['class'=>'img-responsive']);     
            }
            else
            {
                echo Html::img('@web/images/user.jpg', ['class'=>'img-responsive']); 
            }
        ?>
    </div>

    <p class="task-desc"><?= strip_tags($model->descripcion); ?></p>

    <p class="task-button">
        <?= Html::a( Yii::t('app', 'Realizar Entrega').' ('.$entregas.'/'.$model->oportunidades.')', ['tareadesarrollo/create', 'id' => $model->id], ['class' => 'btn btn-xs btn-primary responder', 'style' => 'color: #fff;']); ?>
        <?= Html::a( Yii::t('app', 'Mis Entregas'), ['tareadesarrollo/entregables', 'id' => $model->id], ['class' => 'btn btn-xs btn-warning responder', 'style' => 'color: #fff;']) ?>
    </p>

    <ul class="task-footer" style="padding-bottom: 5px;">
        <li><i class="far fa-bookmark"></i> <?= Html::encode($model->asignaturas->asignatura) ?></li>
        <li><i class="far fa-calendar-alt text-success"></i> Desde <?= Yii::$app->formatter->format($model->disponible_desde, 'datetime'); ?></li>
        <li><i class="far fa-calendar-alt text-danger"></i> Hasta <?= Yii::$app->formatter->format($model->disponible_hasta, 'datetime'); ?></li>
        <li><i class="far fa-clock text-danger"></i> Finaliza <?= Yii::$app->formatter->format($model->disponible_hasta, 'relativeTime'); ?></li>
    </ul>

    
</div>

