<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->terceros,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        'identificacion',
        [
                'attribute' => 'tipos.tipo',
                'label' => 'Tipo'
        ],
        'primer_nombre',
        'segundo_nombre',
        'primer_apellido',
        'segundo_apellido',
        [
                'attribute' => 'generos.genero',
                'label' => 'Genero'
        ],
        'fecha_nacimiento',
        [
                'attribute' => 'departamentos.nombre',
                'label' => 'Departamento Nacimiento'
        ],
        [
                'attribute' => 'municipios.nombre',
                'label' => 'Municipio Nacimiento'
        ],
        [
                'attribute' => 'rhs.rh',
                'label' => 'Rh'
        ],
        [
                'attribute' => 'religiones.religion',
                'label' => 'Religion'
        ],
        [
                'attribute' => 'epss.eps',
                'label' => 'Eps'
        ],
        'direccion',
        [
                'attribute' => 'barrio.barrio',
                'label' => 'Barrio'
        ],
        'fijo',
        'movil',
        'email:email',
        'foto',
        'acudiente',

        [
            'class' => 'yii\grid\ActionColumn',
            'contentOptions'=>['style'=>'width: 80px;'],
            'controller' => 'tercero'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
