<?php
use kartik\grid\GridView;
use kartik\builder\TabularForm;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;
use yii\widgets\Pjax;

Pjax::begin();
$dataProvider = new ArrayDataProvider([
    'allModels' => $row,
    'pagination' => [
        'pageSize' => -1
    ]
]);
echo TabularForm::widget([
    'dataProvider' => $dataProvider,
    'formName' => 'Tercero',
    'checkboxColumn' => false,
    'actionColumn' => false,
    'attributeDefaults' => [
        'type' => TabularForm::INPUT_TEXT,
    ],
    'attributes' => [
        'identificacion' => ['type' => TabularForm::INPUT_TEXT],
        'tipo' => [
            'label' => 'Tipo documento',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Tipodocumento::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Seleccione Tipo documento'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'primer_nombre' => ['type' => TabularForm::INPUT_TEXT],
        'segundo_nombre' => ['type' => TabularForm::INPUT_TEXT],
        'primer_apellido' => ['type' => TabularForm::INPUT_TEXT],
        'segundo_apellido' => ['type' => TabularForm::INPUT_TEXT],
        'genero' => [
            'label' => 'Genero',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Genero::find()->orderBy('genero')->asArray()->all(), 'id', 'genero'),
                'options' => ['placeholder' => 'Seleccione Genero'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'fecha_nacimiento' => ['type' => TabularForm::INPUT_TEXT],
        'departamento_nacimiento' => [
            'label' => 'Departamento',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Departamento::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Seleccione Departamento'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'municipio_nacimiento' => [
            'label' => 'Municipio',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Municipio::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Seleccione Municipio'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'rh' => [
            'label' => 'Rh',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Rh::find()->orderBy('rh')->asArray()->all(), 'id', 'rh'),
                'options' => ['placeholder' => 'Seleccione Rh'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'religion' => [
            'label' => 'Religion',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Religion::find()->orderBy('religion')->asArray()->all(), 'id', 'religion'),
                'options' => ['placeholder' => 'Seleccione Religion'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'eps' => [
            'label' => 'Eps',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Eps::find()->orderBy('eps')->asArray()->all(), 'id', 'eps'),
                'options' => ['placeholder' => 'Seleccione Eps'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'direccion' => ['type' => TabularForm::INPUT_TEXT],
        'barrio' => [
            'label' => 'Barrio',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Barrio::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Seleccione Barrio'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'fijo' => ['type' => TabularForm::INPUT_TEXT],
        'movil' => ['type' => TabularForm::INPUT_TEXT],
        'email' => ['type' => TabularForm::INPUT_TEXT],
        'foto' => ['type' => TabularForm::INPUT_TEXT],
        'acudiente' => ['type' => TabularForm::INPUT_TEXT],
        'estado' => ['type' => TabularForm::INPUT_TEXT],
        'del' => [
            'type' => 'raw',
            'label' => '',
            'value' => function($model, $key) {
                return Html::a('<i class="glyphicon glyphicon-trash"></i>', '#', ['title' =>  'Eliminar', 'onClick' => 'delRowTercero(' . $key . '); return false;', 'id' => 'tercero-del-btn']);
            },
        ],
    ],
    'gridSettings' => [
        'panel' => [
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . 'Tercero',
            'type' => GridView::TYPE_INFO,
            'before' => false,
            'footer' => false,
            'after' => Html::button('<i class="glyphicon glyphicon-plus"></i>' . ' Agregar', ['type' => 'button', 'class' => 'btn btn-success kv-batch-Crear', 'onClick' => 'addRowTercero()']),
        ]
    ]
]);
Pjax::end();
?>
