<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Frd */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Frd', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="frd-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Frd'.' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Delete', ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => 'Are you sure you want to delete this item?',
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'competencia0.competencia',
            'label' => 'Competencia',
        ],
        [
            'attribute' => 'desempeno0.desempeno',
            'label' => 'Desempeno',
        ],
        [
            'attribute' => 'frdTipo.id',
            'label' => 'Frd Tipo',
        ],
        'descripcion:ntext',
        'creado_el',
        'creado_por',
        'actualizado_el',
        'actualizado_por',
        'eliminado_por',
        'eliminado_el',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    <div class="row">
        <h4>Competencia<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnCompetencia = [
        ['attribute' => 'id', 'visible' => false],
        'grado',
        'asignatura',
        'periodo',
        'estandar',
        'creado_el',
        'creado_por',
        'actualizado_el',
        'actualizado_por',
        'eliminado_el',
        'eliminado_por',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->competencia0,
        'attributes' => $gridColumnCompetencia    ]);
    ?>
    <div class="row">
        <h4>Desempeno<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnDesempeno = [
        ['attribute' => 'id', 'visible' => false],
        'tipo_calificacion',
        'limite_inferior',
        'limite_superior',
        'color',
        'nota',
        'creado_el',
        'creado_por',
        'actualizado_el',
        'actualizado_por',
        'eliminado_el',
        'eliminado_por',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->desempeno0,
        'attributes' => $gridColumnDesempeno    ]);
    ?>
    <div class="row">
        <h4>FrdTipo<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnFrdTipo = [
        ['attribute' => 'id', 'visible' => false],
        'tipo',
        'creado_el',
        'creado_por',
        'actualizado_el',
        'actualizado_por',
        'eliminado_por',
        'eliminado_el',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->frdTipo,
        'attributes' => $gridColumnFrdTipo    ]);
    ?>
</div>
