<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;

use kartik\widgets\DepDrop;

use backend\models\Grado;
use backend\models\Asignatura;
use backend\models\Periodo;


$this->registerJs("

$(document).ready(function() {
    
    $('#aplicarFRD').click(function() {

        $('#aplicarFRD').prop('disabled', true);
        id = $('#frd-id').val();
        competencia = $('#frd-competencia').val();
        nivel = $('#frd-nivel').val();
        frd_tipo = $('#frd-frd_tipo').val();
        tipo = $('#frd-frd_tipo option:selected').text();
        descripcion = $('#frd-descripcion').val();
            
        if(!frd_tipo)
        {
            $('.field-frd-frd_tipo > .help-block-error').html('<span style=\"color: #a94442\">Tipo no puede estar vacío.</span>');   
        }

        if(!descripcion)
        {
            $('.field-frd-descripcion > .help-block-error').html('<span style=\"color: #a94442\">Descripción no puede estar vacío.</span>');   
        }

        $.ajax({
            type: 'POST',
            url: '". Url::to(['save'])."',
            timeout: 1000,

            data: {id : id , competencia : competencia, nivel: nivel, frd_tipo : frd_tipo, descripcion: descripcion},

            success: function (data) {
                
                if(data != '')
                {
                    if (frd_tipo == 1) { color = 'success' };
                    if (frd_tipo == 2) { color = 'info' };
                    if (frd_tipo == 3) { color = 'danger' };  
                    if (frd_tipo == 4) { color = 'warning' };
                    
                    $('#no-item').remove();
                    //$('#frd-' + id).remove();

                    //$('#list-' + nivel + ' #list-frd').append('<li class=\"list-group-item d-flex justify-content-between align-items-center\">' + descripcion + '<span class=\"badge badge-' + color +' badge-pill\">' + tipo + '</span></li>');       
                    

                    $('#list-' + nivel + ' #list-frd').append('<li class=\"list-group-item d-flex justify-content-between align-items-center\" id=\"frd-' + data + '\" data-toggle=\"list\" href=\"#list-' + data + '\" role=\"tab\" aria-controls=\"list-' + data + '\" aria-selected=\"false\">' + descripcion + '<div class=\"btn-group\" style=\"float:right; padding-left: 10px;\"><button type=\"button\" class=\"btn btn-xs btn-danger btn-xs\" value=\"/admin/frd/delete?id=' + data + '\" title=\"FRD\" data-toggle=\"tooltip\" style=\"float:right;\" onclick=\"eliminar_frd(' + data + ')\" data-original-title=\"Eliminar\"><i id=\"trash\" class=\"fa fa-trash-alt\" aria-hidden=\"true\"></i></button><button type=\"button\" class=\"showModalButton btn btn-xs btn-success btn-xs\" value=\"../frd/update?id=' + data + '\" title=\"\" data-toggle=\"tooltip\" style=\"float:right;\" data-original-title=\"Editar\"><i id=\"edit\" class=\"fa fa-pencil\" aria-hidden=\"true\"></i></button></div><span class=\"badge badge-' + color + ' badge-pill\">'+ tipo +'</span></a>');
                    
                    $('#modal').modal('hide'); //ocultamos el modal
                    $('body').removeClass('modal-open');    //eliminamos la clase del body para poder hacer scroll
                    $('.modal-backdrop').remove();  //eliminamos el backdrop del modal

                    swal({
                        title: 'Enhorabuena!',
                        text: 'Se agrego satisfactoriamente.',
                        type: 'success',
                        allowOutsideClick: false,
                        timer: 1000,
                    });

                    //location.reload(false);
                }
                    
                
            },
            error: function(request, status, err) {
                if (status == 'timeout') {
                    //timeout -> reload the page and try again
                    $('#info').html(\"<i class='fas fa-times text-danger'></i>\");
                    console.log('timeout');
                    //window.location.reload();
                } else {
                    $('#info').html(\"<span class='text-danger'>\"+ err + \"</span>\");
                    //another error occured  
                    //alert('error: ' + request + status + err);
                }
            }
    
        });
        
    });

});

");

?>

 <?php $form = ActiveForm::begin([
        'validateOnSubmit' => true,
        'enableAjaxValidation' => true,
        //'action' => Url::toRoute('user/ajaxregistration'),
        'validationUrl' => Url::toRoute(['save']),

        'type' => ActiveForm::TYPE_VERTICAL,
        'options' => ['class' => 'main-task-form',
                      'id' => 'formulario',
                      'enctype'=>'multipart/form-data',
                    ]
    ]); ?>

    <div class="row">

        <div class="col-sm-2 hidden-xs">
            <?= Html::img('@web/images/sonic-hero.png', ['class'=>'img-responsive hidden-xs animated bounceInUp','style' => 'position:fixed; z-index:0;']); ?>
        </div>

        <div class="col-sm-10 col-xs-12">
            <?= $form->errorSummary($model); ?>
            
            <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>
            
            <?= $form->field($model, 'competencia', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>
            
            <?= $form->field($model, 'nivel', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>

            <?= $form->field($model, 'frd_tipo')->widget(\kartik\widgets\Select2::classname(), [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Frdtipo::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                'options' => ['placeholder' => Yii::t('app', 'Seleccionar')],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ]); ?>

            <?= $form->field($model, 'descripcion')->textarea(['rows' => 3]) ?>
        </div>





        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="text-align:right; padding-top: 10px;">
            <?= Html::Button($model->isNewRecord ? '<i class="glyphicon glyphicon-plus"></i>' . ' Agregar' : '<i class="glyphicon glyphicon-pencil"></i>' . ' Actualizar', ['type' => 'button', 'class' => $model->isNewRecord ? 'btn btn-primary' : 'btn btn-success', 'id' => 'aplicarFRD']) ?>
            <?= Html::a('<i class="fa fa-times" aria-hidden="true"></i><span> Cancelar', false , ['class'=> 'btn btn-danger', 'data-dismiss' => 'modal']) ?>        
        </div>
        
    </div>
        
<?php ActiveForm::end(); ?>
