<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Frd */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Frd'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="frd-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= Yii::t('app', 'Frd').' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'competencia0.competencia',
            'label' => Yii::t('app', 'Competencia'),
        ],
        [
            'attribute' => 'nivel0.nivel',
            'label' => Yii::t('app', 'Nivel'),
        ],
        [
            'attribute' => 'frdTipo.id',
            'label' => Yii::t('app', 'Frd Tipo'),
        ],
        'descripcion:ntext',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    
    <div class="row">
<?php
if($providerCalificacionFrd->totalCount){
    $gridColumnCalificacionFrd = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
            [
                'attribute' => 'calificacion0.id',
                'label' => Yii::t('app', 'Calificacion')
            ],
                        [
                'attribute' => 'docente0.id',
                'label' => Yii::t('app', 'Docente')
            ],
            [
                'attribute' => 'estudiante0.id',
                'label' => Yii::t('app', 'Estudiante')
            ],
            [
                'attribute' => 'grupo0.grupo',
                'label' => Yii::t('app', 'Grupo')
            ],
            [
                'attribute' => 'asignatura0.asignatura',
                'label' => Yii::t('app', 'Asignatura')
            ],
            [
                'attribute' => 'periodo0.periodo',
                'label' => Yii::t('app', 'Periodo')
            ],
            [
                'attribute' => 'competencia0.competencia',
                'label' => Yii::t('app', 'Competencia')
            ],
            'calificacion_numero',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerCalificacionFrd,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-calificacion-frd']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode(Yii::t('app', 'Calificacion Frd')),
        ],
        'export' => false,
        'columns' => $gridColumnCalificacionFrd
    ]);
}
?>

    </div>
    <div class="row">
        <h4>FrdTipo<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnFrdTipo = [
        ['attribute' => 'id', 'visible' => false],
        'tipo',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->frdTipo,
        'attributes' => $gridColumnFrdTipo    ]);
    ?>
    <div class="row">
        <h4>Nivel<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnNivel = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'competencia0.competencia',
            'label' => Yii::t('app', 'Competencia'),
        ],
        'desempeno',
        'recomendacion',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->nivel0,
        'attributes' => $gridColumnNivel    ]);
    ?>
    <div class="row">
        <h4>Competencia<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnCompetencia = [
        ['attribute' => 'id', 'visible' => false],
        'grado',
        'asignatura',
        'periodo',
        'estandar',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->competencia0,
        'attributes' => $gridColumnCompetencia    ]);
    ?>
</div>
