<div class="form-group" id="add-frd">
<?php
use kartik\grid\GridView;
use kartik\builder\TabularForm;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;
use yii\widgets\Pjax;

$dataProvider = new ArrayDataProvider([
    'allModels' => $row,
    'pagination' => [
        'pageSize' => -1
    ]
]);
echo TabularForm::widget([
    'dataProvider' => $dataProvider,
    'formName' => 'Frd',
    'checkboxColumn' => false,
    'actionColumn' => false,
    'attributeDefaults' => [
        'type' => TabularForm::INPUT_TEXT,
    ],
    'attributes' => [
        "id" => ['type' => TabularForm::INPUT_HIDDEN, 'columnOptions' => ['hidden'=>true]],
        'competencia' => [
            'label' => 'Competencia',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Competencia::find()->orderBy('competencia')->asArray()->all(), 'id', 'competencia'),
                'options' => ['placeholder' => 'Choose Competencia'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'desempeno' => [
            'label' => 'Desempeno',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Desempeno::find()->orderBy('desempeno')->asArray()->all(), 'id', 'desempeno'),
                'options' => ['placeholder' => 'Choose Desempeno'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'descripcion' => ['type' => TabularForm::INPUT_TEXTAREA],
        'creado_el' => ['type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\datecontrol\DateControl::classname(),
            'options' => [
                'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                'saveFormat' => 'php:Y-m-d H:i:s',
                'ajaxConversion' => true,
                'options' => [
                    'pluginOptions' => [
                        'placeholder' => 'Choose Creado El',
                        'autoclose' => true,
                    ]
                ],
            ]
        ],
        'creado_por' => ['type' => TabularForm::INPUT_TEXT],
        'actualizado_el' => ['type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\datecontrol\DateControl::classname(),
            'options' => [
                'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                'saveFormat' => 'php:Y-m-d H:i:s',
                'ajaxConversion' => true,
                'options' => [
                    'pluginOptions' => [
                        'placeholder' => 'Choose Actualizado El',
                        'autoclose' => true,
                    ]
                ],
            ]
        ],
        'actualizado_por' => ['type' => TabularForm::INPUT_TEXT],
        'eliminado_por' => ['type' => TabularForm::INPUT_TEXT],
        'eliminado_el' => ['type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\datecontrol\DateControl::classname(),
            'options' => [
                'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                'saveFormat' => 'php:Y-m-d H:i:s',
                'ajaxConversion' => true,
                'options' => [
                    'pluginOptions' => [
                        'placeholder' => 'Choose Eliminado El',
                        'autoclose' => true,
                    ]
                ],
            ]
        ],
        'estado' => ['type' => TabularForm::INPUT_TEXT],
        'del' => [
            'type' => 'raw',
            'label' => '',
            'value' => function($model, $key) {
                return
                    Html::hiddenInput('Children[' . $key . '][id]', (!empty($model['id'])) ? $model['id'] : "") .
                    Html::a('<i class="glyphicon glyphicon-trash"></i>', '#', ['title' =>  'Delete', 'onClick' => 'delRowFrd(' . $key . '); return false;', 'id' => 'frd-del-btn']);
            },
        ],
    ],
    'gridSettings' => [
        'panel' => [
            'heading' => false,
            'type' => GridView::TYPE_DEFAULT,
            'before' => false,
            'footer' => false,
            'after' => Html::button('<i class="glyphicon glyphicon-plus"></i>' . 'Add Frd', ['type' => 'button', 'class' => 'btn btn-success kv-batch-create', 'onClick' => 'addRowFrd()']),
        ]
    ]
]);
echo  "    </div>\n\n";
?>

