<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->terceros,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        'identificacion',
        [
                'attribute' => 'tipos.tipo',
                'label' => 'Tipo'
        ],
        'primer_nombre',
        'segundo_nombre',
        'primer_apellido',
        'segundo_apellido',
        [
                'attribute' => 'tipoterceros.tipo',
                'label' => 'Tipo de Tercero'
        ],
        'fecha_nacimiento',
        [
                'attribute' => 'departamentos.nombre',
                'label' => 'Departamento Nacimiento'
        ],
        [
                'attribute' => 'municipios.nombre',
                'label' => 'Municipio Nacimiento'
        ],
        [
                'attribute' => 'rhs.rh',
                'label' => 'Rh'
        ],
        [
                'attribute' => 'religiones.religion',
                'label' => 'Religion'
        ],
        [
                'attribute' => 'etnias.etnia',
                'label' => 'Etnia'
        ],
        [
                'attribute' => 'epss.eps',
                'label' => 'Eps'
        ],
        'direccion',
        [
                'attribute' => 'barrios.nombre',
                'label' => 'Barrio'
        ],
        'fijo',
        'movil',
        'email:email',
        'foto',
        [
                'attribute' => 'estado',
                'format' => 'RAW',
                'value' => function($model){
                            return ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>';
                           } 
        ], 
        [
            'class' => 'yii\grid\ActionColumn',
            'contentOptions'=>['style'=>'width: 80px;'],
            'controller' => 'tercero'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
