<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\base\Genero */

$this->title = $model->genero;
$this->params['breadcrumbs'][] = ['label' => 'Generos', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="genero-view">

    <div class="row">
        <div class="col-sm-12">
            <h2><?= 'Género'.' '. Html::encode($this->title) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        'genero',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
    $gridColumnTercero = [
        ['class' => 'yii\grid\SerialColumn'],
        'identificacion',
        [
                'attribute' => 'tipos.tipo',
                'label' => 'Tipo'
        ],
        'primer_nombre',
        'segundo_nombre',
        'primer_apellido',
        'segundo_apellido',
        [
                'attribute' => 'genero.genero',
                'label' => 'Genero'
        ],
        'fecha_nacimiento',
        [
                'attribute' => 'departamento.id',
                'label' => 'Departamento Nacimiento'
        ],
        [
                'attribute' => 'municipio.id',
                'label' => 'Municipio Nacimiento'
        ],
        [
                'attribute' => 'rh.rh',
                'label' => 'Rh'
        ],
        [
                'attribute' => 'religion.religion',
                'label' => 'Religion'
        ],
        [
                'attribute' => 'etnia.etnia',
                'label' => 'Etnia'
        ],
        [
                'attribute' => 'epss.eps',
                'label' => 'Eps'
        ],
        'direccion',
        [
                'attribute' => 'barrio.id',
                'label' => 'Barrio'
        ],
        'fijo',
        'movil',
        'email:email',
        'foto',
        'acudiente',
        [
                'attribute' => 'estado',
                'format' => 'RAW',
                'value' => ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>'
        ], 
    ];
    echo Gridview::widget([
        'dataProvider' => $providerTercero,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-tercero']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Tercero'.' '. $this->title),
        ],
        'columns' => $gridColumnTercero
    ]);
?>
    </div>
</div>
