<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->desempenoniveles,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'asignaturas.asignatura',
                'label' => 'Asignatura'
        ],
        [
                'attribute' => 'periodos.periodo',
                'label' => 'Periodo'
        ],
        [
                'attribute' => 'competencias.competencia',
                'label' => 'Competencia'
        ],
        [
                'attribute' => 'desempenos.desempeno',
                'label' => 'Desempeno'
        ],
        'descripcion:ntext',
        'recomendacion:ntext',
        'estado',
        [
            'class' => 'yii\grid\ActionColumn',
            'controller' => 'desempeno-nivel'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
