<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->planAulas,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'docentes.primer_nombre',
                'label' => 'Docente'
        ],
        'semana_inicio',
        'semana_fin',
        [
                'attribute' => 'asignaturas.asignatura',
                'label' => 'Asignatura'
        ],
        [
                'attribute' => 'grupos.grupo',
                'label' => 'Grupo'
        ],
        //'estandar:ntext',
        [
                'attribute' => 'periodos.periodo',
                'label' => 'Periodo'
        ],
        [
                'attribute' => 'competencias.competencia',
                'label' => 'Competencia'
        ],
        'unidad',
        'nombre_unidad',
        //'horas',
        //'derechos:ntext',
        //'inicio:ntext',
        //'desarrollo:ntext',
        //'cierre:ntext',
        //'formativa:ntext',
        //'articulacion:ntext',
        //'recursos:ntext',
        //'reflexion:ntext',
        //'observaciones:ntext',
        //'estado',
        [
            'class' => 'yii\grid\ActionColumn',
            'controller' => 'plan-aula'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
