<div class="form-group" id="add-asignatura">
<?php
use kartik\grid\GridView;
use kartik\builder\TabularForm;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;
use yii\widgets\Pjax;

$dataProvider = new ArrayDataProvider([
    'allModels' => $row,
    'pagination' => [
        'pageSize' => -1
    ]
]);
echo TabularForm::widget([
    'dataProvider' => $dataProvider,
    'formName' => 'Asignatura',
    'checkboxColumn' => false,
    'actionColumn' => false,
    'attributeDefaults' => [
        'type' => TabularForm::INPUT_TEXT,
    ],
    'attributes' => [
        "id" => ['type' => TabularForm::INPUT_HIDDEN, 'columnOptions' => ['hidden'=>true]],
        'asignatura' => ['type' => TabularForm::INPUT_TEXT],
        'codigo' => ['type' => TabularForm::INPUT_TEXT],
        'intensidad' => ['type' => TabularForm::INPUT_TEXT],
        'area' => [
            'label' => 'Area',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Area::find()->orderBy('area')->asArray()->all(), 'id', 'area'),
                'options' => ['placeholder' => 'Choose Area'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'especialidad' => [
            'label' => 'Especialidad',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Especialidad::find()->orderBy('especialidad')->asArray()->all(), 'id', 'especialidad'),
                'options' => ['placeholder' => 'Choose Especialidad'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'num_calificaciones_saber' => ['type' => TabularForm::INPUT_TEXT],
        'por_calificaciones_saber' => ['type' => TabularForm::INPUT_TEXT],
        'num_calificaciones_ser' => ['type' => TabularForm::INPUT_TEXT],
        'por_calificaciones_ser' => ['type' => TabularForm::INPUT_TEXT],
        'por_asig_area' => ['type' => TabularForm::INPUT_TEXT],
        'estado' => ['type' => TabularForm::INPUT_TEXT],
        'del' => [
            'type' => 'raw',
            'label' => '',
            'value' => function($model, $key) {
                return
                    Html::hiddenInput('Children[' . $key . '][id]', (!empty($model['id'])) ? $model['id'] : "") .
                    Html::a('<i class="glyphicon glyphicon-trash"></i>', '#', ['title' =>  'Delete', 'onClick' => 'delRowAsignatura(' . $key . '); return false;', 'id' => 'asignatura-del-btn']);
            },
        ],
    ],
    'gridSettings' => [
        'panel' => [
            'heading' => false,
            'type' => GridView::TYPE_DEFAULT,
            'before' => false,
            'footer' => false,
            'after' => Html::button('<i class="glyphicon glyphicon-plus"></i>' . 'Add Asignatura', ['type' => 'button', 'class' => 'btn btn-success kv-batch-create', 'onClick' => 'addRowAsignatura()']),
        ]
    ]
]);
echo  "    </div>\n\n";
?>

