<div class="form-group" id="add-grupo">
<?php
use kartik\grid\GridView;
use kartik\builder\TabularForm;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;
use yii\widgets\Pjax;

$dataProvider = new ArrayDataProvider([
    'allModels' => $row,
    'pagination' => [
        'pageSize' => -1
    ]
]);
echo TabularForm::widget([
    'dataProvider' => $dataProvider,
    'formName' => 'Grupo',
    'checkboxColumn' => false,
    'actionColumn' => false,
    'attributeDefaults' => [
        'type' => TabularForm::INPUT_TEXT,
    ],
    'attributes' => [
        "id" => ['type' => TabularForm::INPUT_HIDDEN, 'columnOptions' => ['hidden'=>true]],
        'grupo' => ['type' => TabularForm::INPUT_TEXT],
        'director' => [
            'label' => 'Tercero',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Tercero'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'jornada' => [
            'label' => 'Jornada',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Jornada::find()->orderBy('jornada')->asArray()->all(), 'id', 'jornada'),
                'options' => ['placeholder' => 'Choose Jornada'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'sede' => [
            'label' => 'Sede',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Sede::find()->orderBy('sede')->asArray()->all(), 'id', 'sede'),
                'options' => ['placeholder' => 'Choose Sede'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'metodologia' => [
            'label' => 'Metodologia',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Metodologia::find()->orderBy('metodologia')->asArray()->all(), 'id', 'metodologia'),
                'options' => ['placeholder' => 'Choose Metodologia'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'modalidad' => [
            'label' => 'Modalidad',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Modalidad::find()->orderBy('modalidad')->asArray()->all(), 'id', 'modalidad'),
                'options' => ['placeholder' => 'Choose Modalidad'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'especialidad' => [
            'label' => 'Especialidad',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Especialidad::find()->orderBy('especialidad')->asArray()->all(), 'id', 'especialidad'),
                'options' => ['placeholder' => 'Choose Especialidad'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'estado' => ['type' => TabularForm::INPUT_TEXT],
        'del' => [
            'type' => 'raw',
            'label' => '',
            'value' => function($model, $key) {
                return
                    Html::hiddenInput('Children[' . $key . '][id]', (!empty($model['id'])) ? $model['id'] : "") .
                    Html::a('<i class="glyphicon glyphicon-trash"></i>', '#', ['title' =>  'Delete', 'onClick' => 'delRowGrupo(' . $key . '); return false;', 'id' => 'grupo-del-btn']);
            },
        ],
    ],
    'gridSettings' => [
        'panel' => [
            'heading' => false,
            'type' => GridView::TYPE_DEFAULT,
            'before' => false,
            'footer' => false,
            'after' => Html::button('<i class="glyphicon glyphicon-plus"></i>' . 'Add Grupo', ['type' => 'button', 'class' => 'btn btn-success kv-batch-create', 'onClick' => 'addRowGrupo()']),
        ]
    ]
]);
echo  "    </div>\n\n";
?>

