<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\grado */

$this->title = $model->grado;
$this->params['breadcrumbs'][] = ['label' => 'Grado', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="grado-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Grado'.' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Delete', ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => 'Are you sure you want to delete this item?',
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        'grado',
        'codigo',
        [
            'attribute' => 'tipoCalificaciones.tipo',
            'label' => 'Tipo Calificacion',
        ],
        [
            'attribute' => 'calificacionxcompetencia',
            'label' => 'Calificar',
            'format' => 'RAW',
            'value' => function($model){
                return ($model->calificacionxcompetencia == '1') ? '<center><span class="label label-primary">Por Asignatura</span></center>' : '<center><span class="label label-warning">Por Competencia</span></center>';
            },
        ],
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    
    <div class="row">
<?php
if($providerAsignatura->totalCount){
    $gridColumnAsignatura = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
            'asignatura',
            'codigo',
            'intensidad',
                        [
                'attribute' => 'area0.area',
                'label' => 'Area'
            ],
            [
                'attribute' => 'especialidad0.especialidad',
                'label' => 'Especialidad'
            ],
            'num_calificaciones_saber',
            'por_calificaciones_saber',
            'num_calificaciones_ser',
            'por_calificaciones_ser',
            'por_asig_area',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerAsignatura,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-asignatura']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Asignatura'),
        ],
        'export' => false,
        'columns' => $gridColumnAsignatura
    ]);
}
?>

    </div>
    
    <div class="row">
<?php
if($providerCompetencia->totalCount){
    $gridColumnCompetencia = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
            'competencia:ntext',
                        [
                'attribute' => 'asignatura0.asignatura',
                'label' => 'Asignatura'
            ],
            [
                'attribute' => 'periodo0.periodo',
                'label' => 'Periodo'
            ],
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerCompetencia,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-competencia']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Competencia'),
        ],
        'export' => false,
        'columns' => $gridColumnCompetencia
    ]);
}
?>

    </div>
    
    <div class="row">
<?php
if($providerEstandar->totalCount){
    $gridColumnEstandar = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
                        [
                'attribute' => 'asignaturas.asignatura',
                'label' => 'Asignatura'
            ],
            'estandar:ntext',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerEstandar,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-estandar']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Estandar'),
        ],
        'export' => false,
        'columns' => $gridColumnEstandar
    ]);
}
?>

    </div>
    <div class="row">
        <h4>TipoCalificacion<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnTipoCalificacion = [
        ['attribute' => 'id', 'visible' => false],
        'tipo',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->tipoCalificaciones,
        'attributes' => $gridColumnTipoCalificacion    ]);
    ?>
    
    <div class="row">
<?php
if($providerGrupo->totalCount){
    $gridColumnGrupo = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
                        'grupo',
            [
                'attribute' => 'director0.id',
                'label' => 'Director'
            ],
            [
                'attribute' => 'jornada0.jornada',
                'label' => 'Jornada'
            ],
            [
                'attribute' => 'sede0.sede',
                'label' => 'Sede'
            ],
            [
                'attribute' => 'metodologia0.metodologia',
                'label' => 'Metodologia'
            ],
            [
                'attribute' => 'modalidad0.modalidad',
                'label' => 'Modalidad'
            ],
            [
                'attribute' => 'especialidad0.especialidad',
                'label' => 'Especialidad'
            ],
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerGrupo,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-grupo']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Grupo'),
        ],
        'export' => false,
        'columns' => $gridColumnGrupo
    ]);
}
?>

    </div>
    
    <div class="row">
<?php
if($providerPlanAula->totalCount){
    $gridColumnPlanAula = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
            [
                'attribute' => 'docente0.id',
                'label' => 'Docente'
            ],
            'rango',
            'semana_inicio',
            'semana_fin',
                        [
                'attribute' => 'asignatura0.asignatura',
                'label' => 'Asignatura'
            ],
            [
                'attribute' => 'grupo0.grupo',
                'label' => 'Grupo'
            ],
            'estandar:ntext',
            [
                'attribute' => 'periodo0.periodo',
                'label' => 'Periodo'
            ],
            [
                'attribute' => 'competencia0.competencia',
                'label' => 'Competencia'
            ],
            'unidad',
            'nombre_unidad',
            'horas',
            'derechos:ntext',
            'inicio:ntext',
            'desarrollo:ntext',
            'cierre:ntext',
            'formativa:ntext',
            'articulacion:ntext',
            'recursos:ntext',
            'reflexion:ntext',
            'observaciones:ntext',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerPlanAula,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-plan-aula']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Plan Aula'),
        ],
        'export' => false,
        'columns' => $gridColumnPlanAula
    ]);
}
?>

    </div>
</div>
