<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\base\Grupo */

?>
<div class="grupo-view">

    <div class="row">
        <div class="col-sm-12">
            <h2><?= Html::encode($model->grupo) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        [
            'attribute' => 'grados.grado',
            'label' => 'Grado',
        ],
        'grupo',
        [
            'attribute' => 'director',
            'label' => 'Director',
            'format' => 'RAW',
            'value' => ($model->director == NULL) ? '<h3><span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Sin Director Aún</span></h3>' : $model->directores->nombre,
        ],
        [
            'attribute' => 'jornadas.jornada',
            'label' => 'Jornada',
        ],
        [
            'attribute' => 'sedes.sede',
            'label' => 'Sede',
        ],
        [
            'attribute' => 'metodologias.metodologia',
            'label' => 'Metodología',
        ],
        [
            'attribute' => 'modalidades.modalidad',
            'label' => 'Modalidad',
        ],
        [
            'attribute' => 'especialidades.especialidad',
            'label' => 'Especialidad',
        ],
        [
                'attribute' => 'estado',
                'format' => 'RAW',
                //'value' => ($model->estado == 1) ? '<span class="glyphicon glyphicon-ok text-success"></span>' : '<span class="glyphicon glyphicon-remove text-danger"></span>'
                'value' => ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>',

        ], 
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
</div>