<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use yii\db\Expression;

use backend\models\Sede;
use backend\models\Jornada;
use backend\models\Grado;
use backend\models\Tercero;
use backend\models\Especialidad;
use backend\models\Modalidad;
use backend\models\Metodologia;

?>
         <?php $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario',
                        ]
        ]); ?>


<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información del Grupo</h3>
    </div>

    <div class="panel-body" >

            <?= $form->errorSummary($model); ?>
        <div class="col-sm-3">  
            <?= $form->field($model, 'sede')->widget(Select2::classname(), [
                'data' => ArrayHelper::map(Sede::find()->orderBy('id')->asArray()->all(), 'id', 'sede'),
                'options' => ['placeholder' => 'Seleccione la Sede'],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ]); ?>
        </div>
        <div class="col-sm-3">  
            <?= $form->field($model, 'jornada')->widget(Select2::classname(), [
                'data' => ArrayHelper::map(Jornada::find()->orderBy('id')->asArray()->all(), 'id', 'jornada'),
                'options' => ['placeholder' => 'Seleccione la Jornada'],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ]); ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'grado')->widget(Select2::classname(), [
                'data' => ArrayHelper::map(Grado::find()->orderBy('id')->asArray()->all(), 'id', 'grado'),
                'options' => ['placeholder' => 'Seleccione el Grado'],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ]); ?>
        </div>
        <div class="col-sm-3">  
            <?= $form->field($model, 'grupo')->textInput(['maxlength' => true, 'placeholder' => 'Grupo']) ?>
        </div>
        <div class="col-sm-3">  
            <?= $form->field($model, 'director')->widget(Select2::classname(), [
                'data' => ArrayHelper::map(Tercero::find()->select(['id', new Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->where(['estado' => '5', 'tipo_tercero' => '2'])->asArray()->all(), 'id', 'nombre'),
                'options' => ['placeholder' => 'Seleccione el Director'],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ]); ?>
        </div>
        <div class="col-sm-3">  
            <?= $form->field($model, 'metodologia')->widget(Select2::classname(), [
                'data' => ArrayHelper::map(Metodologia::find()->orderBy('id')->asArray()->all(), 'id', 'metodologia'),
                'options' => ['placeholder' => 'Seleccione la Metodología'],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ]); ?>
        </div>
        <div class="col-sm-3">  
            <?= $form->field($model, 'modalidad')->widget(Select2::classname(), [
                'data' => ArrayHelper::map(Modalidad::find()->orderBy('id')->asArray()->all(), 'id', 'modalidad'),
                'options' => ['placeholder' => 'Seleccione la Modalidad'],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ]); ?>
        </div>
        <div class="col-sm-3">  
            <?= $form->field($model, 'especialidad')->widget(Select2::classname(), [
                'data' => ArrayHelper::map(Especialidad::find()->orderBy('id')->asArray()->all(), 'id', 'especialidad'),
                'options' => ['placeholder' => 'Seleccione la Especialidad'],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ]); ?>
        </div>
        <div class="col-sm-12">  
            <? ($model->isNewRecord) ? $model->estado = true: ''; ?>

            <?= $form->field($model, 'estado')->widget(SwitchInput::classname(), ['pluginOptions' => [
                'size' => 'medium',
                'onColor' => 'success',
                'offColor' => 'danger',
                'onText'=>'Activo',
                'offText'=>'Inactivo'
            ]]) 
            ?>
            <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>
        </div>    
    </div>
</div>

<?php ActiveForm::end(); ?>

