<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\base\Grupo */

$this->title = $model->grupo;
$this->params['breadcrumbs'][] = ['label' => 'Grupos', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="grupo-view">

    <div class="row">
        <div class="col-sm-12">
            <h2><?= 'Grupo'.' '. Html::encode($this->title) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        [
                'attribute' => 'grado.grado',
                'label' => 'Grado'
        ],
        'grupo',
        [
                'attribute' => 'tercero.id',
                'label' => 'Director'
        ],
        [
                'attribute' => 'jornada.jornada',
                'label' => 'Jornada'
        ],
        [
                'attribute' => 'sede.sede',
                'label' => 'Sede'
        ],
        [
                'attribute' => 'metodologia.metodologia',
                'label' => 'Metodologia'
        ],
        [
                'attribute' => 'modalidad.modalidad',
                'label' => 'Modalidad'
        ],
        [
                'attribute' => 'especialidad.especialidad',
                'label' => 'Especialidad'
        ],
        [
                'attribute' => 'estado',
                'format' => 'RAW',
                'value' => ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>'
        ], 
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
    $gridColumnCalificacion = [
        ['class' => 'yii\grid\SerialColumn'],
        'calificacion',
        [
                'attribute' => 'tercero.id',
                'label' => 'Docente'
        ],
        [
                'attribute' => 'tercero.id',
                'label' => 'Estudiante'
        ],
        [
                'attribute' => 'asignatura.asignatura',
                'label' => 'Asignatura'
        ],
        [
                'attribute' => 'grupo.grupo',
                'label' => 'Grupo'
        ],
        'periodo',
        'nivelacion',
        'indicador',
        'observacion',
        [
                'attribute' => 'estado',
                'format' => 'RAW',
                'value' => ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>'
        ], 
    ];
    echo Gridview::widget([
        'dataProvider' => $providerCalificacion,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-calificacion']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Calificacion'.' '. $this->title),
        ],
        'columns' => $gridColumnCalificacion
    ]);
?>
    </div>
</div>
