<?php

use yii\helpers\Html;
use kartik\export\ExportMenu;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;
use yii\helpers\ArrayHelper;
use yii\db\Expression;

use backend\models\Tercero;
use backend\models\Grado;
use backend\models\Sede;
use backend\models\Jornada;
use backend\models\Metodologia;
use backend\models\Modalidad;
use backend\models\Especialidad;


$this->title = 'Grupo';
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];

$search = "$('.search-button').click(function(){
	$('.search-form').toggle(1000);
	return false;
});";
$this->registerJs($search);
?>
<div class="grupo-index">

    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>
    <?php 
    $gridColumn = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'sede',
            'label' => 'Sede',
            'value' => function($model){                   
                return $model->sedes->sede;                   
            },
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => ArrayHelper::map(Sede::find()->asArray()->all(), 'id', 'sede'),
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
            ],
            'filterInputOptions' => ['placeholder' => 'Sede', 'id' => 'grid-grupo-search-sede'],
            'group' => false,
        ],
        [
                'attribute' => 'grado',
                'label' => 'Grado',
                'value' => function($model){                   
                    return $model->grados->grado;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ArrayHelper::map(Grado::find()->asArray()->all(), 'id', 'grado'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Grado', 'id' => 'grid-grupo-search-grado'],
                'group' => false,
            ],
        [
            'attribute' => 'jornada',
            'label' => 'Jornada',
            'value' => function($model){                   
                return $model->jornadas->jornada;                   
            },
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => ArrayHelper::map(Jornada::find()->asArray()->all(), 'id', 'jornada'),
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
            ],
            'filterInputOptions' => ['placeholder' => 'Jornada', 'id' => 'grid-grupo-search-jornada'],
            'group' => false,
        ],
        'grupo',
        [
            'attribute'=>'EstudiantesCount',
            'header'=>'Estudiantes',
            'width'=>'50px',
            'format' => 'raw',
            'value' => function ($model) {
                        //return Html::a('<span class="label label-success">'.$model->AnexosCount.'</span>', 'index.php?AnexosSearch%5B'.$model->id.'%5D&r=anexos');
                        
                        $flat = ($model->EstudiantesCount == 0) ?  "danger" : "success";

                        $link = '<span class="label label-'.$flat.'">'.$model->EstudiantesCount.'</span>';
                        return Html::a($link,['/reporte102', 'grupo' => $model->id],['data-pjax' => '0']);
            },   
        ],
        
        [
                'attribute' => 'director',
                'label' => 'Director',
                'format' => 'raw',
                'value' => function($model){
                    if ($model->directores)
                    {return $model->directores->nombre;}
                    else
                    {return '<span class="label label-danger">Sin Director</span>';}
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ArrayHelper::map(Tercero::find()->select(['id', new Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->where(['tipo_tercero' => '2'])->asArray()->all(), 'id', 'nombre'),

                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => '', 'id' => 'grid-grupo-search-director']
            ],
        [
                'attribute' => 'metodologia',
                'label' => 'Metodologia',
                'value' => function($model){                   
                    return $model->metodologias->metodologia;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ArrayHelper::map(Metodologia::find()->asArray()->all(), 'id', 'metodologia'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Metodologia', 'id' => 'grid-grupo-search-metodologia']
            ],
        [
                'attribute' => 'modalidad',
                'label' => 'Modalidad',
                'value' => function($model){                   
                    return $model->modalidades->modalidad;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ArrayHelper::map(Modalidad::find()->asArray()->all(), 'id', 'modalidad'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Modalidad', 'id' => 'grid-grupo-search-modalidad']
            ],
        [
                'attribute' => 'especialidad',
                'label' => 'Especialidad',
                'value' => function($model){                   
                    return $model->especialidades->especialidad;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ArrayHelper::map(Especialidad::find()->asArray()->all(), 'id', 'especialidad'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Especialidad', 'id' => 'grid-grupo-search-especialidad']
            ],
        [
            'class'=>'kartik\grid\BooleanColumn',
            'attribute'=>'estado', 
            'vAlign'=>'middle'
        ],
        [
            'class' => 'yii\grid\ActionColumn',
        ],
    ]; 
    ?>


<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading' => false,
                //'heading'=>'<i class="fa fa-users"></i>  Terceros',
                //'before' =>  '<div style="padding-top: 7px;"><em>Estudiantes, Docentes, Administrativos y Acudientes.</em></div>',
                //'after' => '{summary}',
                'footer'=> '{summary}',
            ],        
            'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fa fa-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="fa fa-repeat"></i>', ['index'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Volver a Cargar'])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],
        ],
        'options'=>['id'=>'grupo'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>

</div>
