<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

$this->title = 'Grupo '.$model->grupo;
$this->params['breadcrumbs'][] = ['label' => 'Grupo', 'url' => ['index']];
$this->params['breadcrumbs'][] = $model->grupo;

?>
<div class="grupo-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Grupo'.' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Delete', ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => 'Are you sure you want to delete this item?',
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'grados.grado',
            'label' => 'Grado',
        ],
        'grupo',
        [
            'attribute' => 'directores.nombre',
            'label' => 'Director',
        ],
        [
            'attribute' => 'jornadas.jornada',
            'label' => 'Jornada',
        ],
        [
            'attribute' => 'sedes.sede',
            'label' => 'Sede',
        ],
        [
            'attribute' => 'metodologias.metodologia',
            'label' => 'Metodologia',
        ],
        [
            'attribute' => 'modalidades.modalidad',
            'label' => 'Modalidad',
        ],
        [
            'attribute' => 'especialidades.especialidad',
            'label' => 'Especialidad',
        ],
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    
</div>
